/*
 * Decompiled with CFR 0.152.
 */
package com.resources.utils;

import android.content.Context;
import android.content.CursorLoader;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import com.resources.utils.callbacks.OnPhotoImport;
import java.io.File;
import java.io.InputStream;

public class CameraImportTask
extends AsyncTask<Void, FileBitmap, Boolean> {
    private final Uri[] uris;
    private OnPhotoImport onPhotoImport;
    private final Context context;
    private Exception exception;

    public CameraImportTask(Context context, Uri[] uris, OnPhotoImport onPhotoImport) {
        this.context = context;
        this.uris = uris;
        this.onPhotoImport = onPhotoImport;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.onPhotoImport.onStartImport();
    }

    protected Boolean doInBackground(Void ... voids) {
        try {
            for (Uri uri : this.uris) {
                InputStream is = this.context.getContentResolver().openInputStream(uri);
                if (is == null) continue;
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is);
                this.publishProgress(new FileBitmap[]{new FileBitmap(bitmap, uri)});
                is.close();
            }
        }
        catch (Exception e) {
            this.exception = e;
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String getRealPathFromURI(Context context, Uri contentUri) {
        if (Build.VERSION.SDK_INT >= 11) {
            String[] projection = new String[]{"_data"};
            CursorLoader cursorLoader = new CursorLoader(context, contentUri, projection, null, null, null);
            Cursor cursor = cursorLoader.loadInBackground();
            int column_index = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            return cursor.getString(column_index);
        }
        return "";
    }

    protected void onProgressUpdate(FileBitmap ... values) {
        super.onProgressUpdate((Object[])values);
        this.onPhotoImport.onPhotoImport(values[0].bitmap, new File(CameraImportTask.getRealPathFromURI(this.context, values[0].file)));
    }

    protected void onPostExecute(Boolean aBoolean) {
        super.onPostExecute((Object)aBoolean);
        if (!aBoolean.booleanValue()) {
            this.onPhotoImport.onErrorImport(this.exception);
        } else {
            this.onPhotoImport.onSuccessImport();
        }
    }

    class FileBitmap {
        Bitmap bitmap;
        Uri file;

        public FileBitmap(Bitmap bitmap, Uri file) {
            this.bitmap = bitmap;
            this.file = file;
        }
    }
}

