/*
 * Decompiled with CFR 0.152.
 */
package com.ahamed.multiviewadapter.util;

import android.support.annotation.LayoutRes;
import android.support.annotation.RestrictTo;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.ahamed.multiviewadapter.DataItemManager;
import com.ahamed.multiviewadapter.ItemBinder;
import com.ahamed.multiviewadapter.ItemViewHolder;

public abstract class InfiniteLoadingHelper {
    private final InfiniteLoadingBinder itemBinder;
    private final InfiniteScrollListener infiniteScrollListener;
    private final int totalPageCount;
    private DataItemManager<String> dataItemManager;
    private int currentPage;
    private boolean isLoading = false;
    private boolean canLoadMore = false;

    public InfiniteLoadingHelper(@LayoutRes int layoutId) {
        this(layoutId, Integer.MAX_VALUE);
    }

    public InfiniteLoadingHelper(@LayoutRes int layoutId, int totalPageCount) {
        this.itemBinder = new InfiniteLoadingBinder(layoutId);
        this.totalPageCount = totalPageCount;
        this.infiniteScrollListener = new InfiniteScrollListener(this);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public ItemBinder<String, ItemViewHolder<String>> getItemBinder() {
        return this.itemBinder;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setDataItemManager(DataItemManager<String> dataItemManager) {
        this.canLoadMore = true;
        this.dataItemManager = dataItemManager;
    }

    public void markCurrentPageLoaded() {
        this.isLoading = false;
        if (!this.canLoadMore) {
            this.completeLoading();
        }
    }

    public void markAllPagesLoaded() {
        this.completeLoading();
    }

    public RecyclerView.OnScrollListener getScrollListener() {
        return this.infiniteScrollListener;
    }

    public abstract void onLoadNextPage(int var1);

    private void loadNextPage() {
        this.isLoading = true;
        this.onLoadNextPage(this.currentPage++);
        if (this.currentPage == this.totalPageCount) {
            this.canLoadMore = false;
        }
    }

    private void completeLoading() {
        this.canLoadMore = false;
        this.dataItemManager.removeItem();
    }

    private static class InfiniteScrollListener
    extends RecyclerView.OnScrollListener {
        private final InfiniteLoadingHelper loadingHelper;

        InfiniteScrollListener(InfiniteLoadingHelper loadingHelper) {
            this.loadingHelper = loadingHelper;
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            if (dy > 0 && !this.loadingHelper.isLoading && this.loadingHelper.canLoadMore) {
                int totalItemCount = recyclerView.getLayoutManager().getItemCount();
                int lastVisibleItemPosition = 0;
                if (recyclerView.getLayoutManager() instanceof StaggeredGridLayoutManager) {
                    int[] lastVisibleItemPositions = ((StaggeredGridLayoutManager)recyclerView.getLayoutManager()).findLastVisibleItemPositions(null);
                    lastVisibleItemPosition = lastVisibleItemPositions[lastVisibleItemPositions.length - 1];
                } else if (recyclerView.getLayoutManager() instanceof LinearLayoutManager) {
                    lastVisibleItemPosition = ((LinearLayoutManager)recyclerView.getLayoutManager()).findLastVisibleItemPosition();
                }
                if (lastVisibleItemPosition + 1 >= totalItemCount) {
                    this.loadingHelper.loadNextPage();
                }
            }
        }
    }

    private static class InfiniteLoadingBinder
    extends ItemBinder<String, ItemViewHolder<String>> {
        @LayoutRes
        private final int layoutId;

        InfiniteLoadingBinder(@LayoutRes int layoutId) {
            this.layoutId = layoutId;
        }

        @Override
        public final ItemViewHolder<String> create(LayoutInflater inflater, ViewGroup parent) {
            return new ItemViewHolder<String>(inflater.inflate(this.layoutId, parent, false));
        }

        @Override
        public final void bind(ItemViewHolder holder, String item) {
        }

        @Override
        public final boolean canBindData(Object item) {
            return item instanceof String && item.equals("LoadingItem");
        }

        @Override
        public int getSpanSize(int maxSpanCount) {
            return maxSpanCount;
        }
    }
}

