/*
 * Decompiled with CFR 0.152.
 */
package com.ahamed.multiviewadapter;

import android.support.annotation.RestrictTo;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.ahamed.multiviewadapter.listener.ItemActionListener;

public class ItemViewHolder<M>
extends RecyclerView.ViewHolder
implements View.OnClickListener,
View.OnLongClickListener {
    private M item;
    private OnItemClickListener<M> itemClickListener;
    private OnItemLongClickListener<M> itemLongClickListener;
    private ItemActionListener actionListener;

    public ItemViewHolder(View itemView) {
        super(itemView);
        itemView.setOnClickListener((View.OnClickListener)this);
        itemView.setOnLongClickListener((View.OnLongClickListener)this);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void onClick(View view) {
        if (null == this.itemClickListener) {
            return;
        }
        this.itemClickListener.onItemClick(view, this.getItem());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final boolean onLongClick(View view) {
        return null != this.itemLongClickListener && this.itemLongClickListener.onItemLongClick(view, this.getItem());
    }

    final void setItemActionListener(ItemActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public final M getItem() {
        return this.item;
    }

    final void setItem(M item) {
        this.item = item;
    }

    protected final void toggleItemSelection() {
        this.actionListener.onItemSelectionToggled(this.getAdapterPosition());
    }

    protected final void toggleItemExpansion() {
        this.actionListener.onItemExpansionToggled(this.getAdapterPosition());
    }

    protected final void toggleGroupExpansion() {
        this.actionListener.onGroupExpansionToggled(this.getAdapterPosition());
    }

    protected final void setItemClickListener(OnItemClickListener<M> itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    protected final void setItemLongClickListener(OnItemLongClickListener<M> itemLongClickListener) {
        this.itemLongClickListener = itemLongClickListener;
    }

    public final boolean isItemSelected() {
        return this.actionListener.isItemSelected(this.getAdapterPosition());
    }

    public final boolean isItemExpanded() {
        return this.actionListener.isItemExpanded(this.getAdapterPosition());
    }

    public final boolean isInActionMode() {
        return this.actionListener.isAdapterInActionMode();
    }

    public int getSwipeDirections() {
        return 0;
    }

    public int getDragDirections() {
        return 0;
    }

    public final void startDrag() {
        this.actionListener.onStartDrag(this);
    }

    public static interface OnItemLongClickListener<M> {
        public boolean onItemLongClick(View var1, M var2);
    }

    public static interface OnItemClickListener<M> {
        public void onItemClick(View var1, M var2);
    }
}

