/*
 * Decompiled with CFR 0.152.
 */
package com.ahamed.multiviewadapter;

import android.support.annotation.NonNull;
import com.ahamed.multiviewadapter.DataListUpdateManager;
import com.ahamed.multiviewadapter.RecyclerAdapter;
import com.ahamed.multiviewadapter.listener.SwipeToDismissListener;
import com.ahamed.multiviewadapter.util.PayloadProvider;
import java.util.Collection;
import java.util.List;

public final class DataListManager<M>
extends DataListUpdateManager<M> {
    private SwipeToDismissListener<M> swipeToDismissListener;

    public DataListManager(@NonNull RecyclerAdapter adapter) {
        super(adapter);
    }

    public DataListManager(@NonNull RecyclerAdapter adapter, @NonNull PayloadProvider<M> payloadProvider) {
        super(adapter, payloadProvider);
    }

    public final boolean add(M item) {
        return this.add(item, true);
    }

    public final boolean addAll(@NonNull Collection<? extends M> items) {
        return this.addAll(items, true);
    }

    public final boolean addAll(int index, @NonNull Collection<? extends M> items) {
        return this.addAll(index, items, true);
    }

    public final void add(int index, M item) {
        this.add(index, item, true);
    }

    public final void set(int index, M item) {
        this.set(index, item, true);
    }

    public final void set(List<M> dataList) {
        this.set(dataList, true);
    }

    public final void remove(M item) {
        this.remove(item, true);
    }

    public final void remove(int index) {
        this.remove(index, true);
    }

    public final void clear() {
        this.clear(true);
    }

    public void setSwipeToDismissListener(SwipeToDismissListener<M> swipeToDismissListener) {
        this.swipeToDismissListener = swipeToDismissListener;
    }

    void onSwiped(int itemPositionInManager) {
        Object item = this.get(itemPositionInManager);
        this.remove(itemPositionInManager, true);
        if (null != this.swipeToDismissListener) {
            this.swipeToDismissListener.onItemDismissed(itemPositionInManager, item);
        }
    }
}

