/*
 * Decompiled with CFR 0.152.
 */
package com.ahamed.multiviewadapter;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.ahamed.multiviewadapter.CoreRecyclerAdapter;
import com.ahamed.multiviewadapter.ItemBinder;

class ItemDecorationManager
extends RecyclerView.ItemDecoration {
    private final CoreRecyclerAdapter adapter;

    ItemDecorationManager(CoreRecyclerAdapter adapter) {
        this.adapter = adapter;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        boolean isReverseLayout = this.getIsReverseLayout(parent);
        int adapterPosition = parent.getChildAdapterPosition(view);
        if (adapterPosition < 0) {
            return;
        }
        ItemBinder binder = this.adapter.getBinderForPosition(adapterPosition);
        if (binder.isItemDecorationEnabled()) {
            int itemPosition = this.adapter.getItemPositionInManager(parent.getChildAdapterPosition(view));
            int positionType = this.getPositionType(parent, adapterPosition, itemPosition, isReverseLayout);
            binder.getItemOffsets(outRect, itemPosition, positionType);
        }
    }

    public void onDraw(Canvas canvas, RecyclerView parent, RecyclerView.State state) {
        boolean isReverseLayout = this.getIsReverseLayout(parent);
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            int adapterPosition = parent.getChildAdapterPosition(child);
            if (adapterPosition < 0) {
                return;
            }
            ItemBinder binder = this.adapter.getBinderForPosition(adapterPosition);
            if (!binder.isItemDecorationEnabled()) continue;
            int itemPosition = this.adapter.getItemPositionInManager(parent.getChildAdapterPosition(child));
            int positionType = this.getPositionType(parent, adapterPosition, itemPosition, isReverseLayout);
            binder.onDraw(canvas, parent, child, itemPosition, positionType);
        }
    }

    private boolean getIsReverseLayout(RecyclerView parent) {
        return parent.getLayoutManager() instanceof LinearLayoutManager && ((LinearLayoutManager)parent.getLayoutManager()).getReverseLayout();
    }

    private int getPositionType(RecyclerView parent, int adapterPosition, int itemPosition, boolean isReverseLayout) {
        if (parent.getLayoutManager() instanceof GridLayoutManager) {
            return this.getPositionTypeGrid(parent, adapterPosition);
        }
        if (parent.getLayoutManager() instanceof LinearLayoutManager) {
            return this.getPositionTypeLinear(itemPosition, adapterPosition, isReverseLayout);
        }
        return 0;
    }

    private int getPositionTypeGrid(RecyclerView parent, int adapterPosition) {
        GridLayoutManager gridLayoutManager = (GridLayoutManager)parent.getLayoutManager();
        int spanSize = gridLayoutManager.getSpanCount();
        int itemPositionType = 0;
        int totalSpanCount = 0;
        boolean isFirstRow = true;
        for (int looper = 0; looper <= adapterPosition; ++looper) {
            int currentSpanCount = gridLayoutManager.getSpanSizeLookup().getSpanSize(looper);
            if (totalSpanCount + currentSpanCount > spanSize) {
                totalSpanCount = currentSpanCount;
                isFirstRow = false;
            } else {
                totalSpanCount += currentSpanCount;
            }
            if (looper != adapterPosition) continue;
            if (totalSpanCount - currentSpanCount == 0) {
                itemPositionType |= 1;
            }
            if (totalSpanCount == spanSize) {
                itemPositionType |= 4;
            }
            if (isFirstRow) {
                itemPositionType |= 2;
            }
            if (!this.isLastRow(gridLayoutManager, adapterPosition, totalSpanCount, spanSize)) continue;
            itemPositionType |= 8;
        }
        return itemPositionType;
    }

    private boolean isLastRow(GridLayoutManager gridLayoutManager, int adapterPosition, int totalSpanCount, int spanSize) {
        for (int looper = adapterPosition + 1; looper < this.adapter.getItemCount(); ++looper) {
            int currentSpanCount = gridLayoutManager.getSpanSizeLookup().getSpanSize(looper);
            if (totalSpanCount + currentSpanCount > spanSize) {
                return false;
            }
            totalSpanCount += currentSpanCount;
        }
        return true;
    }

    private int getPositionTypeLinear(int itemPosition, int adapterPosition, boolean isReverseLayout) {
        boolean isLastItem;
        boolean isFirstItem;
        boolean bl = isReverseLayout ? this.adapter.isLastItemInManager(adapterPosition, itemPosition) : (isFirstItem = itemPosition == 0);
        boolean bl2 = isReverseLayout ? itemPosition == 0 : (isLastItem = this.adapter.isLastItemInManager(adapterPosition, itemPosition));
        return isFirstItem ? 101 : (isLastItem ? 103 : 102);
    }
}

