/*
 * Decompiled with CFR 0.152.
 */
package com.ahamed.multiviewadapter;

import android.support.annotation.Nullable;
import android.support.v7.util.ListUpdateCallback;
import android.util.SparseBooleanArray;
import com.ahamed.multiviewadapter.RecyclerAdapter;
import com.ahamed.multiviewadapter.SelectableAdapter;
import com.ahamed.multiviewadapter.listener.ItemSelectionChangedListener;
import com.ahamed.multiviewadapter.listener.MultiSelectionChangedListener;
import java.util.ArrayList;
import java.util.List;

class BaseDataManager<M>
implements ListUpdateCallback {
    private final RecyclerAdapter adapter;
    private List<M> dataList = new ArrayList<M>();
    private SparseBooleanArray selectedItems = new SparseBooleanArray();
    private ItemSelectionChangedListener<M> itemSelectionChangedListener;
    private MultiSelectionChangedListener<M> multiSelectionChangedListener;

    BaseDataManager(RecyclerAdapter baseAdapter) {
        this.adapter = baseAdapter;
    }

    public final void onInserted(int position, int count) {
        this.adapter.notifyBinderItemRangeInserted(this, position, count);
    }

    public final void onRemoved(int position, int count) {
        this.adapter.notifyBinderItemRangeRemoved(this, position, count);
    }

    public final void onMoved(int fromPosition, int toPosition) {
        this.adapter.notifyBinderItemMoved(this, fromPosition, toPosition);
    }

    public final void onChanged(int position, int count, Object payload) {
        this.adapter.notifyBinderItemRangeChanged(this, position, count, payload);
    }

    public final List<M> getSelectedItems() {
        ArrayList<M> selectedItemsList = new ArrayList<M>();
        for (int i = 0; i < this.size(); ++i) {
            if (!this.selectedItems.get(i)) continue;
            selectedItemsList.add(this.dataList.get(i));
        }
        return selectedItemsList;
    }

    public final void setSelectedItems(List<M> selectedItems) {
        if (!(this.adapter instanceof SelectableAdapter)) {
            throw new IllegalStateException("Make sure your adapter extends from com.ahamed.multiviewadapter.SelectableAdapter");
        }
        if (this.size() < 0) {
            return;
        }
        SparseBooleanArray oldSelectedItems = this.selectedItems.clone();
        this.selectedItems = new SparseBooleanArray();
        for (M m : selectedItems) {
            boolean isSelected = this.contains(m);
            int index = this.indexOf(m);
            this.selectedItems.put(index, isSelected);
            if (oldSelectedItems.get(index, false) == isSelected) continue;
            this.onItemSelectionToggled(index, isSelected);
        }
    }

    @Nullable
    public final M getSelectedItem() {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.selectedItems.get(i)) continue;
            return this.dataList.get(i);
        }
        return null;
    }

    public final void setSelectedItem(M selectedItem) {
        if (!(this.adapter instanceof SelectableAdapter)) {
            throw new IllegalStateException("Make sure your adapter extends from com.ahamed.multiviewadapter.SelectableAdapter");
        }
        if (this.size() < 0) {
            return;
        }
        M previousSelectedItem = this.getSelectedItem();
        int index = this.indexOf(selectedItem);
        if (index != -1) {
            this.selectedItems.put(index, true);
            this.onItemSelectionToggled(index, true);
            ((SelectableAdapter)this.adapter).setLastSelectedIndex(index);
        }
        if (null != previousSelectedItem && this.indexOf(previousSelectedItem) != -1) {
            this.onItemSelectionToggled(this.indexOf(previousSelectedItem), false);
        }
    }

    public final int getCount() {
        return this.size();
    }

    public final boolean isEmpty() {
        return this.dataList.isEmpty();
    }

    public final boolean contains(M item) {
        return this.dataList.contains(item);
    }

    public final M get(int index) {
        return this.dataList.get(index);
    }

    public final int indexOf(M item) {
        return this.dataList.indexOf(item);
    }

    public final int lastIndexOf(M item) {
        return this.dataList.lastIndexOf(item);
    }

    public void setItemSelectionChangedListener(ItemSelectionChangedListener<M> itemSelectionChangedListener) {
        this.itemSelectionChangedListener = itemSelectionChangedListener;
    }

    public void setMultiSelectionChangedListener(MultiSelectionChangedListener<M> multiSelectionChangedListener) {
        this.multiSelectionChangedListener = multiSelectionChangedListener;
    }

    void onItemSelectionToggled(int position, boolean isSelected) {
        this.selectedItems.put(position, isSelected);
        this.onChanged(position, 1, null);
        if (this.adapter instanceof SelectableAdapter && (this.itemSelectionChangedListener != null || this.multiSelectionChangedListener != null)) {
            SelectableAdapter adapter = (SelectableAdapter)this.adapter;
            switch (adapter.getSelectionMode()) {
                case 3: {
                    if (null == this.multiSelectionChangedListener) break;
                    this.multiSelectionChangedListener.onMultiSelectionChangedListener(this.getSelectedItems());
                    break;
                }
                case 1: 
                case 2: {
                    if (null == this.itemSelectionChangedListener) break;
                    this.itemSelectionChangedListener.onItemSelectionChangedListener(this.get(position), isSelected);
                    break;
                }
            }
        }
    }

    List<M> getDataList() {
        return this.dataList;
    }

    void setDataList(List<M> dataList) {
        this.dataList = new ArrayList<M>(dataList);
    }

    int size() {
        return this.dataList.size();
    }

    M getItem(int dataItemPosition) {
        return this.dataList.get(dataItemPosition);
    }

    boolean isItemSelected(int dataItemPosition) {
        return this.selectedItems.get(dataItemPosition);
    }
}

