/*
 * Decompiled with CFR 0.152.
 */
package com.ahamed.multiviewadapter;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.ahamed.multiviewadapter.BaseViewHolder;
import com.ahamed.multiviewadapter.ItemDecorator;
import java.util.List;

public abstract class ItemBinder<M, VH extends BaseViewHolder<M>> {
    private ItemDecorator itemDecorator;

    public ItemBinder() {
    }

    public ItemBinder(ItemDecorator itemDecorator) {
        this.itemDecorator = itemDecorator;
    }

    public abstract VH create(LayoutInflater var1, ViewGroup var2);

    public abstract void bind(VH var1, M var2);

    public abstract boolean canBindData(Object var1);

    public void bind(VH holder, M item, List payloads) {
        this.bind(holder, item);
    }

    public int getSpanSize(int maxSpanCount) {
        return 1;
    }

    void bindViewHolder(VH holder, M item, boolean isSelected) {
        this.bind(holder, item);
    }

    void bindViewHolder(VH holder, M item, boolean isSelected, List payloads) {
        this.bind(holder, item, payloads);
    }

    VH createViewHolder(LayoutInflater inflater, ViewGroup parent) {
        return this.create(inflater, parent);
    }

    boolean isItemDecorationEnabled() {
        return this.itemDecorator != null;
    }

    void getItemOffsets(Rect outRect, int position, int positionType) {
        if (null != this.itemDecorator) {
            this.itemDecorator.getItemOffsets(outRect, position, positionType);
        }
    }

    void onDraw(Canvas canvas, RecyclerView parent, View child, int position, int positionType) {
        if (null != this.itemDecorator) {
            this.itemDecorator.onDraw(canvas, parent, child, position, positionType);
        }
    }
}

