/*
 * Decompiled with CFR 0.152.
 */
package de.derklaro.projects.deer.executor;

import de.derklaro.projects.deer.api.Database;
import de.derklaro.projects.deer.api.filter.Filter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class BasicDatabase<T extends de.derklaro.projects.deer.api.writer.FileWriter>
implements Database<T> {
    private final File file;
    private final Function<File, T> applier;
    private final int expectedValues;

    public BasicDatabase(File folder, Function<File, T> applier, int values) {
        this.file = folder;
        this.applier = applier;
        this.expectedValues = values;
        if (values < 1) {
            throw new RuntimeException("We cannot handle a database which less than 1 values per key. Database config broken?");
        }
        Properties properties = new Properties();
        properties.setProperty("values", Integer.toString(this.expectedValues));
        try (OutputStream outputStream = Files.newOutputStream(Paths.get(folder.getAbsolutePath(), "config.properties"), StandardOpenOption.CREATE_NEW);){
            properties.store(outputStream, "Database configuration 0x001");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public BasicDatabase(File folder, Function<File, T> applier, Properties properties) {
        this.file = folder;
        this.applier = applier;
        try (InputStream stream = Files.newInputStream(Paths.get(folder.getAbsolutePath(), "config.properties"), new OpenOption[0]);){
            properties.load(stream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        String values = properties.getProperty("values", "-1");
        try {
            this.expectedValues = Integer.parseInt(values);
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException("Expected a number but got " + values + ". Database seems broken");
        }
        if (this.expectedValues < 1) {
            throw new RuntimeException("We cannot handle a database which less than 1 values per key. Database config broken?");
        }
    }

    @NotNull
    public File getTargetFolder() {
        return this.file;
    }

    @NotNull
    public Function<File, T> getApplier() {
        return this.applier;
    }

    public int expectedValues() {
        return this.expectedValues;
    }

    @NotNull
    public Optional<T> getEntry(@NotNull Filter filter) {
        File file = this.getFile(filter);
        return file == null ? Optional.empty() : Optional.ofNullable(this.getApplier().apply(file));
    }

    public void insert(@NotNull String key, @NotNull String[] values, @NotNull T value) {
        String databaseFileName = key + "-" + String.join((CharSequence)"-", values);
        File databaseFile = new File(this.getTargetFolder().getPath(), databaseFileName);
        if (databaseFile.exists()) {
            return;
        }
        if (values.length != this.expectedValues) {
            throw new RuntimeException("Cannot insert database object (expected != given)");
        }
        try {
            if (!databaseFile.createNewFile()) {
                throw new RuntimeException("Cannot create new database file");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try (FileWriter fileWriter = new FileWriter(databaseFile, false);){
            fileWriter.write(value.toWriteableString());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void updateKey(@NotNull Filter target, @NotNull T value) {
        File file = this.getFile(target);
        if (file == null) {
            return;
        }
        try (FileWriter fileWriter = new FileWriter(file, false);){
            fileWriter.write(value.toWriteableString());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void delete(@NotNull Filter filter) {
        File file = this.getFile(filter);
        if (file == null || file.isDirectory()) {
            return;
        }
        try {
            Files.deleteIfExists(file.toPath());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getFile(Filter filter) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.getTargetFolder().toPath());){
            Path next;
            String fileName;
            Iterator<Path> iterator = stream.iterator();
            do {
                if (!iterator.hasNext()) return null;
            } while (!filter.filter(fileName = (next = iterator.next()).getFileName().toString(), (Database)this));
            File file = next.toFile();
            return file;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

