/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.cdi;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBOperations;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBTemplate;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBRepositoryFactory;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.util.Assert;

class DynamoDBRepositoryBean<T>
extends CdiRepositoryBean<T> {
    private final Bean<AmazonDynamoDB> amazonDynamoDBBean;
    private final Bean<DynamoDBMapperConfig> dynamoDBMapperConfigBean;
    private final Bean<DynamoDBOperations> dynamoDBOperationsBean;

    DynamoDBRepositoryBean(BeanManager beanManager, Bean<AmazonDynamoDB> amazonDynamoDBBean, Bean<DynamoDBMapperConfig> dynamoDBMapperConfigBean, Bean<DynamoDBOperations> dynamoDBOperationsBean, Set<Annotation> qualifiers, Class<T> repositoryType) {
        super(qualifiers, repositoryType, beanManager);
        if (dynamoDBOperationsBean == null) {
            Assert.notNull(amazonDynamoDBBean, (String)"amazonDynamoDBBean must not be null!");
        } else {
            Assert.isNull(amazonDynamoDBBean, (String)"Cannot specify both amazonDynamoDB bean and dynamoDBOperationsBean in repository configuration");
            Assert.isNull(dynamoDBMapperConfigBean, (String)"Cannot specify both dynamoDBMapperConfigBean bean and dynamoDBOperationsBean in repository configuration");
        }
        this.amazonDynamoDBBean = amazonDynamoDBBean;
        this.dynamoDBMapperConfigBean = dynamoDBMapperConfigBean;
        this.dynamoDBOperationsBean = dynamoDBOperationsBean;
    }

    protected T create(CreationalContext<T> creationalContext, Class<T> repositoryType, Optional<Object> customImplementation) {
        DynamoDBOperations dynamoDBOperations;
        AmazonDynamoDB amazonDynamoDB = (AmazonDynamoDB)this.getDependencyInstance(this.amazonDynamoDBBean, AmazonDynamoDB.class);
        DynamoDBMapperConfig dynamoDBMapperConfig = this.dynamoDBMapperConfigBean == null ? null : (DynamoDBMapperConfig)this.getDependencyInstance(this.dynamoDBMapperConfigBean, DynamoDBMapperConfig.class);
        DynamoDBOperations dynamoDBOperations2 = dynamoDBOperations = this.dynamoDBOperationsBean == null ? null : (DynamoDBOperations)this.getDependencyInstance(this.dynamoDBOperationsBean, DynamoDBOperations.class);
        if (dynamoDBOperations == null) {
            dynamoDBOperations = new DynamoDBTemplate(amazonDynamoDB, dynamoDBMapperConfig);
        }
        DynamoDBRepositoryFactory factory = new DynamoDBRepositoryFactory(dynamoDBOperations);
        return (T)factory.getRepository(repositoryType);
    }
}

