/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.pngtastic.core.processing.zopfli;

import com.googlecode.pngtastic.core.processing.zopfli.BitWriter;
import com.googlecode.pngtastic.core.processing.zopfli.BlockSplitter;
import com.googlecode.pngtastic.core.processing.zopfli.Cookie;
import com.googlecode.pngtastic.core.processing.zopfli.Hash;
import com.googlecode.pngtastic.core.processing.zopfli.Katajainen;
import com.googlecode.pngtastic.core.processing.zopfli.LongestMatchCache;
import com.googlecode.pngtastic.core.processing.zopfli.LzStore;
import com.googlecode.pngtastic.core.processing.zopfli.Options;
import com.googlecode.pngtastic.core.processing.zopfli.Squeeze;
import com.googlecode.pngtastic.core.processing.zopfli.Util;

final class Deflate {
    private static final int[] REVERSED_BITS = new int[]{0, 16, 8, 24, 4, 20, 12, 28, 2, 18, 10, 26, 6, 22, 14, 30, 1, 17, 9, 25, 5, 21, 13, 29, 3, 19, 11, 27, 7, 23, 15, 31};
    static final int WINDOW_SIZE = 32768;
    static final int WINDOW_MASK = Short.MAX_VALUE;

    Deflate() {
    }

    private static void getFixedTree(int[] llLengths, int[] dLengths) {
        int i;
        for (i = 0; i < 144; ++i) {
            llLengths[i] = 8;
        }
        for (i = 144; i < 256; ++i) {
            llLengths[i] = 9;
        }
        for (i = 256; i < 280; ++i) {
            llLengths[i] = 7;
        }
        for (i = 280; i < 288; ++i) {
            llLengths[i] = 8;
        }
        for (i = 0; i < 32; ++i) {
            dLengths[i] = 5;
        }
    }

    private static int bitReverse(int value, int length) {
        int low = REVERSED_BITS[value & 0x1F];
        int mid = REVERSED_BITS[value >> 5 & 0x1F];
        int hi = REVERSED_BITS[value >> 10 & 0x1F];
        int reversed = low << 10 | mid << 5 | hi;
        return length == 15 ? reversed : reversed >> 15 - length;
    }

    /*
     * Unable to fully structure code
     */
    public static void greedy(Cookie cookie, LongestMatchCache lmc, byte[] input, int from, int to, LzStore store) {
        h = cookie.h;
        h.init(input, Math.max(from - 32768, 0), from, to);
        prevLength = 0;
        prevMatch = 0;
        dummySubLen = cookie.c259a;
        matchAvailable = false;
        for (i = from; i < to; ++i) {
            h.updateHash(input, i, to);
            Deflate.findLongestMatch(cookie, lmc, from, h, input, i, to, 258, dummySubLen);
            len = cookie.lenVal;
            dist = cookie.distVal;
            lengthScore = dist > 1024 ? len - 1 : len;
            v0 = prevLengthScore = prevMatch > 1024 ? prevLength - 1 : prevLength;
            if (!matchAvailable) ** GOTO lbl29
            matchAvailable = false;
            if (lengthScore > prevLengthScore + 1) {
                store.append((char)(input[i - 1] & 255), '\u0000');
                if (lengthScore >= 3 && len < 258) {
                    matchAvailable = true;
                    prevLength = len;
                    prevMatch = dist;
                    continue;
                }
            } else {
                store.append((char)prevLength, (char)prevMatch);
                for (j = 2; j < prevLength; ++j) {
                    h.updateHash(input, ++i, to);
                }
                continue;
lbl29:
                // 1 sources

                if (lengthScore >= 3 && len < 258) {
                    matchAvailable = true;
                    prevLength = len;
                    prevMatch = dist;
                    continue;
                }
            }
            if (lengthScore >= 3) {
                store.append((char)len, (char)dist);
            } else {
                len = 1;
                store.append((char)(input[i] & 255), '\u0000');
            }
            for (j = 1; j < len; ++j) {
                h.updateHash(input, ++i, to);
            }
        }
    }

    static void findLongestMatch(Cookie cookie, LongestMatchCache lmc, int blockStart, Hash h, byte[] array, int pos, int size, int limit, char[] subLen) {
        int p;
        int dist;
        char[] lmcLength;
        int offset = pos - blockStart;
        char[] cArray = lmcLength = lmc != null ? lmc.length : null;
        if (lmc != null && (lmcLength[offset] == '\u0000' || lmc.dist[offset] != '\u0000') && (limit == 258 || lmcLength[offset] <= limit || subLen != null && lmc.maxCachedSubLen(offset) >= limit)) {
            if (subLen == null || lmcLength[offset] <= lmc.maxCachedSubLen(offset)) {
                cookie.lenVal = Math.min(lmcLength[offset], limit);
                if (subLen != null) {
                    lmc.cacheToSubLen(offset, cookie.lenVal, subLen);
                    cookie.distVal = subLen[cookie.lenVal];
                } else {
                    cookie.distVal = lmc.dist[offset];
                }
                return;
            }
            limit = lmcLength[offset];
        }
        if (size - pos < 3) {
            cookie.lenVal = 0;
            cookie.distVal = 0;
            return;
        }
        if (pos + limit > size) {
            limit = size - pos;
        }
        int bestDist = 0;
        int bestLength = 1;
        int arrayEnd = pos + limit;
        char[] hPrev = h.prev;
        char[] hPrev2 = h.prev2;
        int pp = h.head[h.val];
        int threshold = h.same[pp];
        int[] hashVal2 = h.hashVal2;
        int marker = hashVal2[pp];
        int n = dist = (pp -= (p = hPrev[pp])) > 0 ? pp : pp + 32768;
        for (int chainCounter = 8192; dist < 32768 && chainCounter > 0; dist += (pp -= p) > 0 ? pp : 32768 + pp, --chainCounter) {
            int scan = pos;
            int match = pos - dist;
            if (array[scan + bestLength] == array[match + bestLength]) {
                int same0 = h.same[pos & Short.MAX_VALUE];
                if (same0 > 2 && array[scan] == array[match]) {
                    int same;
                    int same1 = h.same[match & Short.MAX_VALUE];
                    int n2 = same = same0 < same1 ? same0 : same1;
                    if (same > limit) {
                        same = limit;
                    }
                    scan += same;
                    match += same;
                }
                while (scan != arrayEnd && array[scan] == array[match]) {
                    ++scan;
                    ++match;
                }
                if ((scan -= pos) > bestLength) {
                    if (subLen != null) {
                        for (int j = bestLength + 1; j <= scan; ++j) {
                            subLen[j] = (char)dist;
                        }
                    }
                    bestDist = dist;
                    bestLength = scan;
                    if (scan >= limit) break;
                }
            }
            if (hPrev != hPrev2 && bestLength >= threshold && marker == hashVal2[p]) {
                hPrev = hPrev2;
            }
            if ((p = hPrev[p]) == (pp = p)) break;
        }
        if (lmc != null && limit == 258 && subLen != null && lmcLength[offset] != '\u0000' && lmc.dist[offset] == '\u0000') {
            if (bestLength < 3) {
                lmc.dist[offset] = '\u0000';
                lmcLength[offset] = '\u0000';
            } else {
                lmc.dist[offset] = (char)bestDist;
                lmcLength[offset] = (char)bestLength;
            }
            lmc.subLenToCache(subLen, offset, bestLength);
        }
        cookie.distVal = bestDist;
        cookie.lenVal = bestLength;
    }

    static void deflatePart(Cookie cookie, Options options, byte[] input, int from, int to, boolean flush, BitWriter output) {
        switch (options.blockSplitting) {
            case FIRST: {
                Deflate.deflateSplittingFirst(cookie, options, flush, input, from, to, output);
                break;
            }
            case LAST: {
                Deflate.deflateSplittingLast(cookie, options, flush, input, from, to, output);
                break;
            }
            case NONE: {
                Deflate.deflateDynamicBlock(cookie, options, flush, input, from, to, output);
            }
        }
    }

    private static void deflateDynamicBlock(Cookie cookie, Options options, boolean flush, byte[] input, int from, int to, BitWriter output) {
        LongestMatchCache lmc = cookie.lmc;
        lmc.init(to - from);
        BlockType type = BlockType.DYNAMIC;
        LzStore store = Squeeze.optimal(cookie, options.numIterations, lmc, input, from, to);
        if (store.size < 1000) {
            LzStore fixedStore = cookie.store1;
            fixedStore.reset();
            Squeeze.bestFixedLengths(cookie, lmc, input, from, to, cookie.lengthArray, cookie.costs);
            Squeeze.optimalRun(cookie, lmc, input, from, to, cookie.lengthArray, fixedStore);
            int dynCost = Deflate.calculateBlockSize(cookie, store.litLens, store.dists, 0, store.size);
            int fixedCost = Deflate.calculateFixedBlockSize(cookie, fixedStore.litLens, fixedStore.dists, fixedStore.size);
            if (fixedCost < dynCost) {
                type = BlockType.FIXED;
                store = fixedStore;
            }
        }
        Deflate.addLzBlock(cookie, type, flush, store.litLens, store.dists, 0, store.size, output);
    }

    private static void deflateSplittingLast(Cookie cookie, Options options, boolean flush, byte[] input, int from, int to, BitWriter output) {
        LongestMatchCache lmc = cookie.lmc;
        lmc.init(to - from);
        LzStore store = Squeeze.optimal(cookie, options.numIterations, lmc, input, from, to);
        int nPoints = BlockSplitter.splitLz(cookie, store.litLens, store.dists, store.size);
        int[] splitPoints = cookie.splitPoints;
        for (int i = 1; i <= nPoints; ++i) {
            int start = splitPoints[i - 1];
            int end = splitPoints[i];
            Deflate.addLzBlock(cookie, BlockType.DYNAMIC, i == nPoints && flush, store.litLens, store.dists, start, end, output);
        }
    }

    private static void deflateSplittingFirst(Cookie cookie, Options options, boolean flush, byte[] input, int from, int to, BitWriter output) {
        int nPoints = BlockSplitter.split(cookie, input, from, to);
        int[] splitPoints = cookie.splitPoints;
        for (int i = 1; i <= nPoints; ++i) {
            Deflate.deflateDynamicBlock(cookie, options, i == nPoints && flush, input, splitPoints[i - 1], splitPoints[i], output);
        }
    }

    static int calculateBlockSize(Cookie cookie, char[] litLens, char[] dists, int lStart, int lEnd) {
        int i;
        int[] llLengths = cookie.i288a;
        System.arraycopy(Cookie.intZeroes, 0, llLengths, 0, 288);
        int[] dLengths = cookie.i32a;
        System.arraycopy(Cookie.intZeroes, 0, dLengths, 0, 32);
        int result = 3;
        int[] llCounts = cookie.i288b;
        System.arraycopy(Cookie.intZeroes, 0, llCounts, 0, 288);
        int[] dCounts = cookie.i32b;
        System.arraycopy(Cookie.intZeroes, 0, dCounts, 0, 32);
        int[] lengthSymbol = Util.LENGTH_SYMBOL;
        int[] cachedDistSymbol = Util.CACHED_DIST_SYMBOL;
        int[] lengthExtraBits = Util.LENGTH_EXTRA_BITS;
        for (int i2 = lStart; i2 < lEnd; ++i2) {
            int distSymbol;
            char d = dists[i2];
            char l = litLens[i2];
            if (d == '\u0000') {
                char c = l;
                llCounts[c] = llCounts[c] + 1;
                continue;
            }
            int n = lengthSymbol[l];
            llCounts[n] = llCounts[n] + 1;
            int n2 = distSymbol = cachedDistSymbol[d];
            dCounts[n2] = dCounts[n2] + 1;
            result += lengthExtraBits[l];
            if (distSymbol <= 3) continue;
            result += distSymbol / 2 - 1;
        }
        llCounts[256] = 1;
        int[] llCountsCopy = cookie.i288c;
        System.arraycopy(llCounts, 0, llCountsCopy, 0, 288);
        Deflate.optimizeHuffmanForRle(cookie, llCountsCopy);
        Katajainen.lengthLimitedCodeLengths(cookie, llCountsCopy, 15, llLengths);
        int[] dCountsCopy = cookie.i32c;
        System.arraycopy(dCounts, 0, dCountsCopy, 0, 32);
        Deflate.optimizeHuffmanForRle(cookie, dCountsCopy);
        Katajainen.lengthLimitedCodeLengths(cookie, dCountsCopy, 15, dLengths);
        Deflate.patchDistanceCodesForBuggyDecoders(dLengths);
        result += Deflate.simulateAddDynamicTree(cookie, llLengths, dLengths);
        for (i = 0; i < 288; ++i) {
            result += llCounts[i] * llLengths[i];
        }
        for (i = 0; i < 32; ++i) {
            result += dCounts[i] * dLengths[i];
        }
        return result;
    }

    private static int calculateFixedBlockSize(Cookie cookie, char[] litLens, char[] dists, int size) {
        int[] llLengths = cookie.i288a;
        int[] dLengths = cookie.i32a;
        Deflate.getFixedTree(llLengths, dLengths);
        int result = 3;
        int[] cachedDistExtraBits = Util.CACHED_DIST_EXTRA_BITS;
        int[] lengthExtraBits = Util.LENGTH_EXTRA_BITS;
        int[] lengthSymbol = Util.LENGTH_SYMBOL;
        for (int i = 0; i < size; ++i) {
            char d = dists[i];
            char l = litLens[i];
            if (d == '\u0000') {
                result += llLengths[l];
                continue;
            }
            result += llLengths[lengthSymbol[l]];
            result += lengthExtraBits[l];
            result += 5;
            result += d < '\u1001' ? cachedDistExtraBits[d] : (d < '\u4001' ? (d < '\u2001' ? 11 : 12) : 13);
        }
        return result += llLengths[256];
    }

    private static void lzCounts(char[] litLens, char[] dists, int start, int end, int[] llCount, int[] dCount) {
        int[] lengthSymbol = Util.LENGTH_SYMBOL;
        int[] cachedDistSymbol = Util.CACHED_DIST_SYMBOL;
        for (int i = start; i < end; ++i) {
            char d = dists[i];
            char l = litLens[i];
            if (d == '\u0000') {
                char c = l;
                llCount[c] = llCount[c] + 1;
                continue;
            }
            int n = lengthSymbol[l];
            llCount[n] = llCount[n] + 1;
            int n2 = cachedDistSymbol[d];
            dCount[n2] = dCount[n2] + 1;
        }
        llCount[256] = 1;
    }

    private static void patchDistanceCodesForBuggyDecoders(int[] dLengths) {
        int numDistCodes = 0;
        for (int i = 0; i < 30; ++i) {
            if (dLengths[i] == 0 || ++numDistCodes != 2) continue;
            return;
        }
        if (numDistCodes == 0) {
            dLengths[0] = 1;
            dLengths[1] = 1;
        } else if (numDistCodes == 1) {
            dLengths[dLengths[0] != 0 ? 1 : 0] = 1;
        }
    }

    private static void addDynamicTree(Cookie cookie, int[] llLengths, int[] dLengths, BitWriter output) {
        int best = 0;
        int bestSize = Integer.MAX_VALUE;
        for (int i = 0; i < 8; ++i) {
            int size = Deflate.simulateEncodeTree(cookie, llLengths, dLengths, (i & 1) != 0, (i & 2) != 0, (i & 4) != 0);
            if (size >= bestSize) continue;
            bestSize = size;
            best = i;
        }
        Deflate.encodeTree(cookie, llLengths, dLengths, best & true, (best & 2) != 0, (best & 4) != 0, output);
    }

    private static void encodeTree(Cookie cookie, int[] llLengths, int[] dLengths, boolean use16, boolean use17, boolean use18, BitWriter output) {
        int i;
        int hcLen;
        int hLit;
        int hDist = 29;
        for (hLit = 29; hLit > 0 && llLengths[256 + hLit] == 0; --hLit) {
        }
        while (hDist > 0 && dLengths[hDist] == 0) {
            --hDist;
        }
        int lldTotal = hLit + 258 + hDist;
        int[] lldLengths = cookie.i320b;
        System.arraycopy(llLengths, 0, lldLengths, 0, 257 + hLit);
        System.arraycopy(dLengths, 0, lldLengths, 257 + hLit, hDist + 1);
        int rleSize = 0;
        int[] rle = cookie.i320a;
        int[] rleBits = cookie.i320c;
        for (int i2 = 0; i2 < lldTotal; ++i2) {
            int delta;
            int count = 1;
            int symbol = lldLengths[i2];
            if (use16 || symbol == 0 && (use17 || use18)) {
                for (int j = i2 + 1; j < lldTotal && symbol == lldLengths[j]; ++j) {
                    ++count;
                }
            }
            i2 += count - 1;
            if (symbol == 0 && count > 2) {
                if (use18) {
                    while (count > 10) {
                        delta = count > 138 ? 138 : count;
                        rle[rleSize] = 18;
                        rleBits[rleSize++] = delta - 11;
                        count -= delta;
                    }
                }
                if (use17) {
                    while (count > 2) {
                        delta = count > 10 ? 10 : count;
                        rle[rleSize] = 17;
                        rleBits[rleSize++] = delta - 3;
                        count -= delta;
                    }
                }
            }
            if (use16 && count > 3) {
                --count;
                rle[rleSize] = symbol;
                rleBits[rleSize++] = 0;
                while (count > 2) {
                    delta = count > 6 ? 6 : count;
                    rle[rleSize] = 16;
                    rleBits[rleSize++] = delta - 3;
                    count -= delta;
                }
            }
            while (count != 0) {
                rle[rleSize] = symbol;
                rleBits[rleSize++] = 0;
                --count;
            }
        }
        int[] clCounts = cookie.i19a;
        System.arraycopy(Cookie.intZeroes, 0, clCounts, 0, 19);
        for (int i3 = 0; i3 < rleSize; ++i3) {
            int n = rle[i3];
            clCounts[n] = clCounts[n] + 1;
        }
        int[] clCl = cookie.i19b;
        System.arraycopy(Cookie.intZeroes, 0, clCl, 0, 19);
        Katajainen.lengthLimitedCodeLengths(cookie, clCounts, 7, clCl);
        int[] clSymbols = cookie.i19c;
        Deflate.lengthsToSymbols(clCl, 19, 7, clSymbols, cookie.i16a, cookie.i16b);
        int[] order = Util.ORDER;
        for (hcLen = 15; hcLen > 0 && clCounts[order[hcLen + 3]] == 0; --hcLen) {
        }
        output.addBits(hLit, 5);
        output.addBits(hDist, 5);
        output.addBits(hcLen, 4);
        for (i = 0; i < hcLen + 4; ++i) {
            output.addBits(clCl[order[i]], 3);
        }
        block16: for (i = 0; i < rleSize; ++i) {
            int symbol = clSymbols[rle[i]];
            output.addBits(symbol, clCl[rle[i]]);
            switch (rle[i]) {
                case 16: {
                    output.addBits(rleBits[i], 2);
                    continue block16;
                }
                case 17: {
                    output.addBits(rleBits[i], 3);
                    continue block16;
                }
                case 18: {
                    output.addBits(rleBits[i], 7);
                    continue block16;
                }
            }
        }
    }

    private static int simulateAddDynamicTree(Cookie cookie, int[] llLengths, int[] dLengths) {
        int bestSize = Integer.MAX_VALUE;
        for (int i = 0; i < 8; ++i) {
            int size = Deflate.simulateEncodeTree(cookie, llLengths, dLengths, (i & 1) != 0, (i & 2) != 0, (i & 4) != 0);
            if (size >= bestSize) continue;
            bestSize = size;
        }
        return bestSize;
    }

    private static int simulateEncodeTree(Cookie cookie, int[] llLengths, int[] dLengths, boolean use16, boolean use17, boolean use18) {
        int hcLen;
        int hLit;
        int hDist = 29;
        for (hLit = 29; hLit > 0 && llLengths[256 + hLit] == 0; --hLit) {
        }
        while (hDist > 0 && dLengths[hDist] == 0) {
            --hDist;
        }
        int lldTotal = hLit + 258 + hDist;
        int[] lldLengths = cookie.i320b;
        System.arraycopy(llLengths, 0, lldLengths, 0, 257 + hLit);
        System.arraycopy(dLengths, 0, lldLengths, 257 + hLit, hDist + 1);
        int[] rle = cookie.i320a;
        int rleSize = 0;
        for (int i = 0; i < lldTotal; ++i) {
            int count = 1;
            int symbol = lldLengths[i];
            if (use16 || symbol == 0 && (use17 || use18)) {
                for (int j = i + 1; j < lldTotal && symbol == lldLengths[j]; ++j) {
                    ++count;
                }
            }
            i += count - 1;
            if (symbol == 0 && count > 2) {
                if (use18) {
                    while (count > 10) {
                        rle[rleSize++] = 18;
                        count -= count > 138 ? 138 : count;
                    }
                }
                if (use17) {
                    while (count > 2) {
                        rle[rleSize++] = 17;
                        count -= count > 10 ? 10 : count;
                    }
                }
            }
            if (use16 && count > 3) {
                --count;
                rle[rleSize++] = symbol;
                while (count > 2) {
                    rle[rleSize++] = 16;
                    count -= count > 6 ? 6 : count;
                }
            }
            while (count != 0) {
                rle[rleSize++] = symbol;
                --count;
            }
        }
        int[] clCounts = cookie.i19a;
        System.arraycopy(Cookie.intZeroes, 0, clCounts, 0, 19);
        for (int i = 0; i < rleSize; ++i) {
            int n = rle[i];
            clCounts[n] = clCounts[n] + 1;
        }
        int[] clCl = cookie.i19b;
        System.arraycopy(Cookie.intZeroes, 0, clCl, 0, 19);
        Katajainen.lengthLimitedCodeLengths(cookie, clCounts, 7, clCl);
        clCl[16] = clCl[16] + 2;
        clCl[17] = clCl[17] + 3;
        clCl[18] = clCl[18] + 7;
        int[] order = Util.ORDER;
        for (hcLen = 15; hcLen > 0 && clCounts[order[hcLen + 3]] == 0; --hcLen) {
        }
        int result = 14 + (hcLen + 4) * 3;
        for (int i = 0; i < 19; ++i) {
            result += clCl[i] * clCounts[i];
        }
        return result;
    }

    private static void addLzBlock(Cookie cookie, BlockType type, boolean last, char[] litLens, char[] dists, int lStart, int lEnd, BitWriter output) {
        int[] llLengths = cookie.i288a;
        System.arraycopy(Cookie.intZeroes, 0, llLengths, 0, 288);
        int[] dLengths = cookie.i32a;
        System.arraycopy(Cookie.intZeroes, 0, dLengths, 0, 32);
        int[] llCounts = cookie.i288b;
        System.arraycopy(Cookie.intZeroes, 0, llCounts, 0, 288);
        int[] dCounts = cookie.i32b;
        System.arraycopy(Cookie.intZeroes, 0, dCounts, 0, 32);
        output.addBits(last ? 1 : 0, 1);
        if (type == BlockType.FIXED) {
            output.addBits(1, 2);
        } else {
            output.addBits(2, 2);
        }
        if (type == BlockType.FIXED) {
            Deflate.getFixedTree(llLengths, dLengths);
        } else {
            Deflate.lzCounts(litLens, dists, lStart, lEnd, llCounts, dCounts);
            Deflate.optimizeHuffmanForRle(cookie, llCounts);
            Katajainen.lengthLimitedCodeLengths(cookie, llCounts, 15, llLengths);
            Deflate.optimizeHuffmanForRle(cookie, dCounts);
            Katajainen.lengthLimitedCodeLengths(cookie, dCounts, 15, dLengths);
            Deflate.patchDistanceCodesForBuggyDecoders(dLengths);
            Deflate.addDynamicTree(cookie, llLengths, dLengths, output);
        }
        int[] llSymbols = cookie.i288c;
        System.arraycopy(Cookie.intZeroes, 0, llSymbols, 0, 288);
        Deflate.lengthsToSymbols(llLengths, 288, 15, llSymbols, cookie.i16a, cookie.i16b);
        int[] dSymbols = cookie.i32b;
        System.arraycopy(Cookie.intZeroes, 0, dSymbols, 0, 32);
        Deflate.lengthsToSymbols(dLengths, 32, 15, dSymbols, cookie.i16a, cookie.i16b);
        Deflate.addLzData(litLens, dists, lStart, lEnd, llSymbols, llLengths, dSymbols, dLengths, output);
        output.addBits(llSymbols[256], llLengths[256]);
    }

    private static void addLzData(char[] litLens, char[] dists, int lStart, int lEnd, int[] llSymbols, int[] llLengths, int[] dSymbols, int[] dLengths, BitWriter output) {
        int[] cachedDistExtraBits = Util.CACHED_DIST_EXTRA_BITS;
        int[] lengthExtraBits = Util.LENGTH_EXTRA_BITS;
        int[] lengthExtraBitsValue = Util.LENGTH_EXTRA_BITS_VALUE;
        int[] lengthSymbol = Util.LENGTH_SYMBOL;
        int[] cachedDistSymbol = Util.CACHED_DIST_SYMBOL;
        for (int i = lStart; i < lEnd; ++i) {
            char dist = dists[i];
            char litLen = litLens[i];
            if (dist == '\u0000') {
                output.addBits(llSymbols[litLen], llLengths[litLen]);
                continue;
            }
            int lls = lengthSymbol[litLen];
            int ds = cachedDistSymbol[dist];
            output.addBits(llSymbols[lls], llLengths[lls]);
            output.addBits(lengthExtraBitsValue[litLen], lengthExtraBits[litLen]);
            output.addBits(dSymbols[ds], dLengths[ds]);
            output.addBits(Util.distExtraBitsValue(dist), dist < '\u1001' ? cachedDistExtraBits[dist] : (dist < '\u4001' ? (dist < '\u2001' ? 11 : 12) : 13));
        }
    }

    private static void lengthsToSymbols(int[] lengths, int n, int maxBits, int[] symbols, int[] blCount, int[] nextCode) {
        System.arraycopy(Cookie.intZeroes, 0, blCount, 0, maxBits + 1);
        System.arraycopy(Cookie.intZeroes, 0, nextCode, 0, maxBits + 1);
        for (int i = 0; i < n; ++i) {
            int n2 = lengths[i];
            blCount[n2] = blCount[n2] + 1;
        }
        int code = 0;
        blCount[0] = 0;
        for (int bits = 1; bits <= maxBits; ++bits) {
            nextCode[bits] = code = code + blCount[bits - 1] << 1;
        }
        for (int i = 0; i < n; ++i) {
            int len = lengths[i];
            if (len == 0) continue;
            symbols[i] = Deflate.bitReverse(nextCode[len], len);
            int n3 = len;
            nextCode[n3] = nextCode[n3] + 1;
        }
    }

    private static void optimizeHuffmanForRle(Cookie cookie, int[] counts) {
        int length;
        int[] goodForRle = cookie.i289a;
        for (length = counts.length; length >= 0; --length) {
            if (length == 0) {
                return;
            }
            if (counts[length - 1] != 0) break;
        }
        System.arraycopy(Cookie.intZeroes, 0, goodForRle, 0, length + 1);
        int symbol = counts[0];
        int stride = 0;
        for (int i = 0; i < length + 1; ++i) {
            if (i == length || counts[i] != symbol) {
                if (symbol == 0 && stride >= 5 || symbol != 0 && stride >= 7) {
                    for (int k = 0; k < stride; ++k) {
                        goodForRle[i - k - 1] = 1;
                    }
                }
                stride = 1;
                if (i == length) continue;
                symbol = counts[i];
                continue;
            }
            ++stride;
        }
        stride = 0;
        int limit = counts[0];
        int sum = 0;
        for (int i = 0; i < length + 1; ++i) {
            if (i == length || goodForRle[i] != 0 || counts[i] - limit >= 4 || limit - counts[i] >= 4) {
                if (stride >= 4 || stride >= 3 && sum == 0) {
                    int count = (sum + stride / 2) / stride;
                    if (count < 1) {
                        count = 1;
                    }
                    if (sum == 0) {
                        count = 0;
                    }
                    for (int k = 0; k < stride; ++k) {
                        counts[i - k - 1] = count;
                    }
                }
                stride = 0;
                sum = 0;
                limit = i < length - 3 ? (counts[i] + counts[i + 1] + counts[i + 2] + counts[i + 3] + 2) / 4 : (i < length ? counts[i] : 0);
            }
            ++stride;
            if (i == length) continue;
            sum += counts[i];
        }
    }

    static enum BlockType {
        DYNAMIC,
        FIXED;

    }
}

