/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.pngtastic.core.processing.zopfli;

import com.googlecode.pngtastic.core.processing.zopfli.ZopfliRuntimeException;
import java.io.IOException;
import java.io.OutputStream;

final class BitWriter {
    static final int PAGE_SIZE = 4096;
    int offset;
    private final byte[] data = new byte[4097];
    private int bitOffset;
    private int accumulator;
    private final OutputStream output;

    BitWriter(OutputStream output) {
        this.output = output;
    }

    void jumpToByteBoundary() {
        int paddingBits = 8 - (this.bitOffset & 7);
        if (paddingBits != 8) {
            this.addBits(0, paddingBits);
        }
    }

    void addBits(int value, int length) {
        this.accumulator |= value << this.bitOffset;
        this.bitOffset += length;
        while (this.bitOffset >= 8) {
            this.data[this.offset++] = (byte)this.accumulator;
            this.bitOffset -= 8;
            this.accumulator >>= 8;
        }
        if (this.offset >= 4096) {
            try {
                this.flush();
            }
            catch (IOException ex) {
                throw new ZopfliRuntimeException("Failed to push output", ex);
            }
        }
    }

    void flush() throws IOException {
        int slice = this.offset > 4096 ? 4096 : this.offset;
        this.output.write(this.data, 0, slice);
        this.offset -= slice;
        this.data[0] = this.data[4096];
    }
}

