/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.pngtastic.core.processing;

import com.googlecode.pngtastic.core.Logger;
import com.googlecode.pngtastic.core.processing.Base64;
import com.googlecode.pngtastic.core.processing.PngByteArrayOutputStream;
import com.googlecode.pngtastic.core.processing.PngCompressionHandler;
import com.googlecode.pngtastic.core.processing.zopfli.Options;
import com.googlecode.pngtastic.core.processing.zopfli.Zopfli;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ZopfliCompressionHandler
implements PngCompressionHandler {
    private static final int DEFAULT_ITERATIONS = 15;
    private final Options options;
    private final Logger log;
    private final Zopfli zopfli;

    public ZopfliCompressionHandler(Logger log) {
        this(log, 15);
    }

    public ZopfliCompressionHandler(Logger log, int iterations) {
        this.log = log;
        this.zopfli = new Zopfli(0x800000);
        this.options = new Options(Options.OutputFormat.ZLIB, Options.BlockSplitting.FIRST, iterations);
    }

    @Override
    public byte[] deflate(PngByteArrayOutputStream inflatedImageData, Integer compressionLevel, boolean concurrent) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.zopfli.compress(this.options, inflatedImageData.toByteArray(), byteArrayOutputStream);
        this.log.debug("Compression strategy: zopfli, bytes=%d", byteArrayOutputStream.size());
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public String encodeBytes(byte[] bytes) {
        return Base64.encodeBytes(bytes);
    }
}

