/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.pngtastic.core;

import com.googlecode.pngtastic.core.Logger;
import com.googlecode.pngtastic.core.PngChunk;
import com.googlecode.pngtastic.core.PngException;
import com.googlecode.pngtastic.core.PngImage;
import com.googlecode.pngtastic.core.processing.PngByteArrayOutputStream;
import com.googlecode.pngtastic.core.processing.PngCompressionHandler;
import com.googlecode.pngtastic.core.processing.PngFilterHandler;
import com.googlecode.pngtastic.core.processing.PngInterlaceHandler;
import com.googlecode.pngtastic.core.processing.PngtasticCompressionHandler;
import com.googlecode.pngtastic.core.processing.PngtasticFilterHandler;
import com.googlecode.pngtastic.core.processing.PngtasticInterlaceHandler;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.InflaterInputStream;

public abstract class PngProcessor {
    protected final Logger log;
    protected final PngFilterHandler pngFilterHandler;
    protected final PngInterlaceHandler pngInterlaceHandler;
    protected PngCompressionHandler pngCompressionHandler;

    protected PngProcessor(String logLevel) {
        this.log = new Logger(logLevel);
        this.pngFilterHandler = new PngtasticFilterHandler(this.log);
        this.pngInterlaceHandler = new PngtasticInterlaceHandler(this.log, this.pngFilterHandler);
        this.pngCompressionHandler = new PngtasticCompressionHandler(this.log);
    }

    protected PngByteArrayOutputStream getInflatedImageData(PngChunk chunk, Iterator<PngChunk> itChunks) throws IOException {
        PngByteArrayOutputStream imageBytes = new PngByteArrayOutputStream(chunk == null ? 0 : chunk.getLength());
        try (DataOutputStream imageData = new DataOutputStream(imageBytes);){
            while (chunk != null && "IDAT".equals(chunk.getTypeString())) {
                imageData.write(chunk.getData());
                chunk = itChunks.hasNext() ? itChunks.next() : null;
            }
            PngByteArrayOutputStream pngByteArrayOutputStream = this.inflate(imageBytes);
            return pngByteArrayOutputStream;
        }
    }

    public PngByteArrayOutputStream inflate(PngByteArrayOutputStream bytes) throws IOException {
        try (PngByteArrayOutputStream inflatedOut = new PngByteArrayOutputStream();){
            PngByteArrayOutputStream pngByteArrayOutputStream;
            try (InflaterInputStream inflater = new InflaterInputStream(new ByteArrayInputStream(bytes.get(), 0, bytes.len()));){
                int readLength;
                byte[] block = new byte[8192];
                while ((readLength = inflater.read(block)) != -1) {
                    inflatedOut.write(block, 0, readLength);
                }
                pngByteArrayOutputStream = inflatedOut;
            }
            return pngByteArrayOutputStream;
        }
    }

    protected List<byte[]> getScanlines(PngByteArrayOutputStream inflatedImageData, int sampleBitCount, int rowLength, long height) {
        ArrayList<byte[]> rows = new ArrayList<byte[]>(Math.max((int)height, 0));
        byte[] previousRow = new byte[rowLength];
        int i = 0;
        while ((long)i < height) {
            int offset = i * rowLength;
            byte[] row = new byte[rowLength];
            System.arraycopy(inflatedImageData.get(), offset, row, 0, rowLength);
            try {
                this.pngFilterHandler.deFilter(row, previousRow, sampleBitCount);
                rows.add(row);
                previousRow = (byte[])row.clone();
            }
            catch (PngException e) {
                this.log.error("Error: %s", e.getMessage());
            }
            ++i;
        }
        return rows;
    }

    protected PngChunk processHeadChunks(PngImage result, boolean removeGamma, Iterator<PngChunk> itChunks) throws IOException {
        PngChunk chunk = null;
        while (itChunks.hasNext() && !"IDAT".equals((chunk = itChunks.next()).getTypeString())) {
            if (result == null || !chunk.isRequired() || removeGamma && "GAMA".equalsIgnoreCase(chunk.getTypeString())) continue;
            PngChunk newChunk = new PngChunk(chunk.getType(), (byte[])chunk.getData().clone());
            if ("IHDR".equals(chunk.getTypeString())) {
                newChunk.setInterlace((byte)0);
            }
            result.addChunk(newChunk);
        }
        return chunk;
    }

    protected void printData(byte[] inflatedImageData) {
        StringBuilder result = new StringBuilder();
        for (byte b : inflatedImageData) {
            result.append(String.format("%2x|", b));
        }
        this.log.debug(result.toString(), new Object[0]);
    }
}

