/*
 * Decompiled with CFR 0.152.
 */
package com.denzcoskun.imageslider.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.viewpager.widget.PagerAdapter;
import com.denzcoskun.imageslider.R;
import com.denzcoskun.imageslider.constants.ActionTypes;
import com.denzcoskun.imageslider.constants.ScaleTypes;
import com.denzcoskun.imageslider.interfaces.ItemClickListener;
import com.denzcoskun.imageslider.interfaces.TouchListener;
import com.denzcoskun.imageslider.models.SlideModel;
import com.denzcoskun.imageslider.transformation.RoundedTransformation;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.RequestCreator;
import com.squareup.picasso.Transformation;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001BE\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eBO\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0011J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\bH\u0016J\u000e\u0010 \u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bH\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u001eH\u0016J\u000e\u0010'\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010(\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/denzcoskun/imageslider/adapters/ViewPagerAdapter;", "Landroidx/viewpager/widget/PagerAdapter;", "context", "Landroid/content/Context;", "imageList", "", "Lcom/denzcoskun/imageslider/models/SlideModel;", "radius", "", "errorImage", "placeholder", "titleBackground", "textAlign", "", "(Landroid/content/Context;Ljava/util/List;IIIILjava/lang/String;)V", "scaleType", "Lcom/denzcoskun/imageslider/constants/ScaleTypes;", "(Landroid/content/Context;Ljava/util/List;IIIILcom/denzcoskun/imageslider/constants/ScaleTypes;Ljava/lang/String;)V", "itemClickListener", "Lcom/denzcoskun/imageslider/interfaces/ItemClickListener;", "layoutInflater", "Landroid/view/LayoutInflater;", "touchListener", "Lcom/denzcoskun/imageslider/interfaces/TouchListener;", "destroyItem", "", "container", "Landroid/view/ViewGroup;", "position", "object", "", "getCount", "getGravityFromAlign", "instantiateItem", "Landroid/view/View;", "isViewFromObject", "", "view", "obj", "setItemClickListener", "setTouchListener", "imageslider_release"})
public final class ViewPagerAdapter
extends PagerAdapter {
    private List<SlideModel> imageList;
    private LayoutInflater layoutInflater;
    private ItemClickListener itemClickListener;
    private TouchListener touchListener;
    private int radius;
    private int errorImage;
    private int placeholder;
    private int titleBackground;
    private ScaleTypes scaleType;
    private String textAlign;

    public boolean isViewFromObject(@NotNull View view, @NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        return Intrinsics.areEqual((Object)view, (Object)obj);
    }

    public int getCount() {
        List<SlideModel> list = this.imageList;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return list.size();
    }

    @NotNull
    public View instantiateItem(@NotNull ViewGroup container, int position) {
        RequestCreator loader;
        ImageView imageView;
        View itemView;
        block21: {
            block24: {
                block23: {
                    block22: {
                        block20: {
                            block19: {
                                RequestCreator requestCreator;
                                Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
                                LayoutInflater layoutInflater = this.layoutInflater;
                                if (layoutInflater == null) {
                                    Intrinsics.throwNpe();
                                }
                                itemView = layoutInflater.inflate(R.layout.pager_row, container, false);
                                imageView = (ImageView)itemView.findViewById(R.id.image_view);
                                LinearLayout linearLayout = (LinearLayout)itemView.findViewById(R.id.linear_layout);
                                TextView textView = (TextView)itemView.findViewById(R.id.text_view);
                                List<SlideModel> list = this.imageList;
                                if (list == null) {
                                    Intrinsics.throwNpe();
                                }
                                if (list.get(position).getTitle() != null) {
                                    TextView textView2 = textView;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"textView");
                                    List<SlideModel> list2 = this.imageList;
                                    if (list2 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    textView2.setText((CharSequence)list2.get(position).getTitle());
                                    linearLayout.setBackgroundResource(this.titleBackground);
                                    textView.setGravity(this.getGravityFromAlign(this.textAlign));
                                    LinearLayout linearLayout2 = linearLayout;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout2, (String)"linearLayout");
                                    linearLayout2.setGravity(this.getGravityFromAlign(this.textAlign));
                                } else {
                                    LinearLayout linearLayout3 = linearLayout;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout3, (String)"linearLayout");
                                    linearLayout3.setVisibility(4);
                                }
                                List<SlideModel> list3 = this.imageList;
                                if (list3 == null) {
                                    Intrinsics.throwNpe();
                                }
                                if (list3.get(position).getImageUrl() == null) {
                                    Picasso picasso = Picasso.get();
                                    List<SlideModel> list4 = this.imageList;
                                    if (list4 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    Integer n = list4.get(position).getImagePath();
                                    if (n == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    requestCreator = picasso.load(n.intValue());
                                } else {
                                    Picasso picasso = Picasso.get();
                                    List<SlideModel> list5 = this.imageList;
                                    if (list5 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    String string = list5.get(position).getImageUrl();
                                    if (string == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    requestCreator = loader = picasso.load(string);
                                }
                                if (this.scaleType != null && this.scaleType == ScaleTypes.CENTER_CROP) break block19;
                                List<SlideModel> list6 = this.imageList;
                                if (list6 == null) {
                                    Intrinsics.throwNpe();
                                }
                                if (list6.get(position).getScaleType() != ScaleTypes.CENTER_CROP) break block20;
                            }
                            loader.fit().centerCrop();
                            break block21;
                        }
                        if (this.scaleType != null && this.scaleType == ScaleTypes.CENTER_INSIDE) break block22;
                        List<SlideModel> list = this.imageList;
                        if (list == null) {
                            Intrinsics.throwNpe();
                        }
                        if (list.get(position).getScaleType() != ScaleTypes.CENTER_INSIDE) break block23;
                    }
                    loader.fit().centerInside();
                    break block21;
                }
                if (this.scaleType != null && this.scaleType == ScaleTypes.FIT) break block24;
                List<SlideModel> list = this.imageList;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                if (list.get(position).getScaleType() != ScaleTypes.FIT) break block21;
            }
            loader.fit();
        }
        loader.transform((Transformation)new RoundedTransformation(this.radius, 0, null, 4, null)).placeholder(this.placeholder).error(this.errorImage).into(imageView);
        container.addView(itemView);
        imageView.setOnClickListener(new View.OnClickListener(this, position){
            final /* synthetic */ ViewPagerAdapter this$0;
            final /* synthetic */ int $position;

            public final void onClick(View it) {
                block0: {
                    ItemClickListener itemClickListener = ViewPagerAdapter.access$getItemClickListener$p(this.this$0);
                    if (itemClickListener == null) break block0;
                    itemClickListener.onItemSelected(this.$position);
                }
            }
            {
                this.this$0 = viewPagerAdapter;
                this.$position = n;
            }
        });
        ImageView imageView2 = imageView;
        if (imageView2 == null) {
            Intrinsics.throwNpe();
        }
        imageView2.setOnTouchListener(new View.OnTouchListener(this){
            final /* synthetic */ ViewPagerAdapter this$0;

            public final boolean onTouch(View v, MotionEvent event) {
                MotionEvent motionEvent = event;
                Intrinsics.checkExpressionValueIsNotNull((Object)motionEvent, (String)"event");
                switch (motionEvent.getAction()) {
                    case 2: {
                        TouchListener touchListener = ViewPagerAdapter.access$getTouchListener$p(this.this$0);
                        if (touchListener == null) {
                            Intrinsics.throwNpe();
                        }
                        touchListener.onTouched(ActionTypes.MOVE);
                        break;
                    }
                    case 0: {
                        TouchListener touchListener = ViewPagerAdapter.access$getTouchListener$p(this.this$0);
                        if (touchListener == null) {
                            Intrinsics.throwNpe();
                        }
                        touchListener.onTouched(ActionTypes.DOWN);
                        break;
                    }
                    case 1: {
                        TouchListener touchListener = ViewPagerAdapter.access$getTouchListener$p(this.this$0);
                        if (touchListener == null) {
                            Intrinsics.throwNpe();
                        }
                        touchListener.onTouched(ActionTypes.UP);
                        break;
                    }
                }
                return false;
            }
            {
                this.this$0 = viewPagerAdapter;
            }
        });
        View view = itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
        return view;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int getGravityFromAlign(@NotNull String textAlign) {
        Intrinsics.checkParameterIsNotNull((Object)textAlign, (String)"textAlign");
        String string = textAlign;
        switch (string.hashCode()) {
            case 1984282709: {
                if (!string.equals("CENTER")) return 3;
                return 17;
            }
            case 77974012: {
                if (!string.equals("RIGHT")) return 3;
                return 5;
            }
        }
        return 3;
    }

    public final void setItemClickListener(@NotNull ItemClickListener itemClickListener) {
        Intrinsics.checkParameterIsNotNull((Object)itemClickListener, (String)"itemClickListener");
        this.itemClickListener = itemClickListener;
    }

    public final void setTouchListener(@NotNull TouchListener touchListener) {
        Intrinsics.checkParameterIsNotNull((Object)touchListener, (String)"touchListener");
        this.touchListener = touchListener;
    }

    public void destroyItem(@NotNull ViewGroup container, int position, @NotNull Object object) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"object");
        container.removeView((View)((RelativeLayout)object));
    }

    public ViewPagerAdapter(@Nullable Context context, @NotNull List<SlideModel> imageList, int radius, int errorImage, int placeholder, int titleBackground, @Nullable ScaleTypes scaleType, @NotNull String textAlign) {
        Intrinsics.checkParameterIsNotNull(imageList, (String)"imageList");
        Intrinsics.checkParameterIsNotNull((Object)textAlign, (String)"textAlign");
        this.radius = radius;
        this.errorImage = errorImage;
        this.placeholder = placeholder;
        this.titleBackground = titleBackground;
        this.scaleType = scaleType;
        this.textAlign = textAlign;
        this.imageList = imageList;
        Context context2 = context;
        if (context2 == null) {
            Intrinsics.throwNpe();
        }
        this.layoutInflater = (LayoutInflater)context2.getSystemService("layout_inflater");
    }

    public ViewPagerAdapter(@NotNull Context context, @NotNull List<SlideModel> imageList, int radius, int errorImage, int placeholder, int titleBackground, @NotNull String textAlign) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(imageList, (String)"imageList");
        Intrinsics.checkParameterIsNotNull((Object)textAlign, (String)"textAlign");
        this(context, imageList, radius, errorImage, placeholder, titleBackground, null, textAlign);
    }

    public static final /* synthetic */ ItemClickListener access$getItemClickListener$p(ViewPagerAdapter $this) {
        return $this.itemClickListener;
    }

    public static final /* synthetic */ void access$setItemClickListener$p(ViewPagerAdapter $this, ItemClickListener itemClickListener) {
        $this.itemClickListener = itemClickListener;
    }

    public static final /* synthetic */ TouchListener access$getTouchListener$p(ViewPagerAdapter $this) {
        return $this.touchListener;
    }

    public static final /* synthetic */ void access$setTouchListener$p(ViewPagerAdapter $this, TouchListener touchListener) {
        $this.touchListener = touchListener;
    }
}

