/*
 * Decompiled with CFR 0.152.
 */
package com.github.demono;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Message;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.animation.Interpolator;
import com.github.demono.CustomDurationScroller;
import com.github.demono.R;
import com.github.demono.adapter.InfinitePagerAdapter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;

public class AutoScrollViewPager
extends ViewPager {
    private static final String TAG = "AutoScrollViewPager";
    private static final int DEFAULT_SLIDE_INTERVAL = 5000;
    private int slideInterval = 5000;
    private static final int DEFAULT_SLIDE_DURATION = 800;
    private int slideDuration = 800;
    public static final int DIRECTION_RIGHT = 1;
    public static final int DIRECTION_LEFT = 0;
    private int direction = 1;
    private boolean stopWhenTouch = true;
    private static final int MSG_SCROLL = 1;
    private boolean cycle;
    private boolean isAutoScroll;
    private boolean isStopedWhenTouch;
    private MyHandler mHandler;
    private CustomDurationScroller mScroller;
    private ViewPager.SimpleOnPageChangeListener mOnPageChangeListener = new ViewPager.SimpleOnPageChangeListener(){

        public void onPageScrollStateChanged(int state) {
            super.onPageScrollStateChanged(state);
            if (state == 0 && AutoScrollViewPager.this.getAdapter() != null && AutoScrollViewPager.this.getAdapter() instanceof InfinitePagerAdapter) {
                int cur = AutoScrollViewPager.this.getCurrentItem();
                int lastReal = AutoScrollViewPager.this.getAdapter().getCount() - 2;
                if (cur == 0) {
                    AutoScrollViewPager.this.setCurrentItem(lastReal, false);
                } else if (cur > lastReal) {
                    AutoScrollViewPager.this.setCurrentItem(1, false);
                }
            }
        }
    };

    public AutoScrollViewPager(Context context) {
        super(context);
        this.init(context, null);
    }

    public AutoScrollViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        this.mHandler = new MyHandler(this);
        this.setScroller();
        if (attrs != null) {
            TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.AutoScrollViewPager, 0, 0);
            try {
                this.slideInterval = array.getInt(R.styleable.AutoScrollViewPager_slideInterval, 5000);
                this.direction = array.getInt(R.styleable.AutoScrollViewPager_slideDirection, 1);
                this.stopWhenTouch = array.getBoolean(R.styleable.AutoScrollViewPager_stopWhenTouch, true);
                this.cycle = array.getBoolean(R.styleable.AutoScrollViewPager_cycle, false);
                this.slideDuration = array.getInt(R.styleable.AutoScrollViewPager_slideDirection, 800);
            }
            finally {
                array.recycle();
            }
        }
    }

    public void setAdapter(PagerAdapter adapter) {
        super.setAdapter(adapter);
        if (adapter != null && adapter instanceof InfinitePagerAdapter && adapter.getCount() > 1) {
            int midPos = (adapter.getCount() - 2) / 2 - (adapter.getCount() - 2) / 2 % ((InfinitePagerAdapter)adapter).getItemCount() + 1;
            this.setCurrentItem(midPos);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.mOnPageChangeListener);
    }

    private void scroll() {
        int nextItem;
        int totalCount;
        PagerAdapter adapter = this.getAdapter();
        int currentItem = this.getCurrentItem();
        if (adapter == null || (totalCount = adapter.getCount()) <= 1) {
            return;
        }
        int n = nextItem = this.direction == 1 ? ++currentItem : --currentItem;
        if (!(this.getAdapter() instanceof InfinitePagerAdapter) && this.cycle) {
            if (nextItem < 0) {
                this.setCurrentItem(totalCount - 1, true);
            } else if (nextItem == totalCount) {
                this.setCurrentItem(0, true);
            } else {
                this.setCurrentItem(nextItem, true);
            }
        } else {
            this.setCurrentItem(nextItem, true);
        }
    }

    private void setScroller() {
        try {
            Field scrollerField = ViewPager.class.getDeclaredField("mScroller");
            scrollerField.setAccessible(true);
            Field interpolatorField = ViewPager.class.getDeclaredField("sInterpolator");
            interpolatorField.setAccessible(true);
            this.mScroller = new CustomDurationScroller(this.getContext(), (Interpolator)interpolatorField.get(null));
            this.mScroller.setDuration(this.slideDuration);
            scrollerField.set((Object)this, (Object)this.mScroller);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startAutoScroll() {
        if (this.getAdapter().getCount() <= 1) {
            return;
        }
        this.isAutoScroll = true;
        this.sendScrollMsg(this.slideInterval);
    }

    public void startAutoScroll(int delayTime) {
        this.isAutoScroll = true;
        this.slideInterval = delayTime;
        this.setScroller();
        this.sendScrollMsg(delayTime);
    }

    public void stopAutoScroll() {
        this.isAutoScroll = false;
        this.mHandler.removeMessages(1);
    }

    private void sendScrollMsg(long delayTime) {
        this.mHandler.removeMessages(1);
        this.mHandler.sendEmptyMessageDelayed(1, delayTime);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        if (this.stopWhenTouch) {
            switch (action) {
                case 0: {
                    if (!this.isAutoScroll) break;
                    this.isStopedWhenTouch = true;
                    this.stopAutoScroll();
                    break;
                }
                case 1: 
                case 4: {
                    if (!this.isStopedWhenTouch) break;
                    this.startAutoScroll();
                }
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this.mOnPageChangeListener);
    }

    public int getSlideInterval() {
        return this.slideInterval;
    }

    public void setSlideInterval(int slideInterval) {
        this.slideInterval = slideInterval;
        this.setScroller();
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public boolean isStopWhenTouch() {
        return this.stopWhenTouch;
    }

    public void setStopWhenTouch(boolean stopWhenTouch) {
        this.stopWhenTouch = stopWhenTouch;
    }

    public boolean isCycle() {
        return this.cycle;
    }

    public void setCycle(boolean cycle) {
        this.cycle = cycle;
    }

    public void setSlideDuration(int slideDuration) {
        this.slideDuration = slideDuration;
    }

    private static class MyHandler
    extends Handler {
        private WeakReference<AutoScrollViewPager> hostWeakReference;

        public MyHandler(AutoScrollViewPager host) {
            this.hostWeakReference = new WeakReference<AutoScrollViewPager>(host);
        }

        public void handleMessage(Message msg) {
            AutoScrollViewPager host = (AutoScrollViewPager)((Object)this.hostWeakReference.get());
            if (host != null) {
                host.scroll();
                host.sendScrollMsg(host.slideInterval);
            }
        }
    }
}

