/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.annotation;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import sun.misc.Unsafe;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.AnnotationTypeMismatchExceptionProxy;
import sun.reflect.annotation.ExceptionProxy;

class AnnotationInvocationHandler
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 6182022883658399397L;
    private final Class<? extends Annotation> type;
    private final Map<String, Object> memberValues;
    private volatile transient Method[] memberMethods = null;

    AnnotationInvocationHandler(Class<? extends Annotation> type, Map<String, Object> memberValues) {
        Class<?>[] superInterfaces = type.getInterfaces();
        if (!type.isAnnotation() || superInterfaces.length != 1 || superInterfaces[0] != Annotation.class) {
            throw new AnnotationFormatError("Attempt to create proxy for a non-annotation type.");
        }
        this.type = type;
        this.memberValues = memberValues;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        String member = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        if (member.equals("equals") && paramTypes.length == 1 && paramTypes[0] == Object.class) {
            return this.equalsImpl(args[0]);
        }
        if (paramTypes.length != 0) {
            throw new AssertionError((Object)"Too many parameters for an annotation method");
        }
        switch (member) {
            case "toString": {
                return this.toStringImpl();
            }
            case "hashCode": {
                return this.hashCodeImpl();
            }
            case "annotationType": {
                return this.type;
            }
        }
        Object result = this.memberValues.get(member);
        if (result == null) {
            throw new IncompleteAnnotationException(this.type, member);
        }
        if (result instanceof ExceptionProxy) {
            throw ((ExceptionProxy)result).generateException();
        }
        if (result.getClass().isArray() && Array.getLength(result) != 0) {
            result = this.cloneArray(result);
        }
        return result;
    }

    private Object cloneArray(Object array) {
        Class<?> type = array.getClass();
        if (type == byte[].class) {
            byte[] byteArray = (byte[])array;
            return byteArray.clone();
        }
        if (type == char[].class) {
            char[] charArray = (char[])array;
            return charArray.clone();
        }
        if (type == double[].class) {
            double[] doubleArray = (double[])array;
            return doubleArray.clone();
        }
        if (type == float[].class) {
            float[] floatArray = (float[])array;
            return floatArray.clone();
        }
        if (type == int[].class) {
            int[] intArray = (int[])array;
            return intArray.clone();
        }
        if (type == long[].class) {
            long[] longArray = (long[])array;
            return longArray.clone();
        }
        if (type == short[].class) {
            short[] shortArray = (short[])array;
            return shortArray.clone();
        }
        if (type == boolean[].class) {
            boolean[] booleanArray = (boolean[])array;
            return booleanArray.clone();
        }
        Object[] objectArray = (Object[])array;
        return objectArray.clone();
    }

    private String toStringImpl() {
        StringBuilder result = new StringBuilder(128);
        result.append('@');
        result.append(this.type.getName());
        result.append('(');
        boolean firstMember = true;
        for (Map.Entry<String, Object> e : this.memberValues.entrySet()) {
            if (firstMember) {
                firstMember = false;
            } else {
                result.append(", ");
            }
            result.append(e.getKey());
            result.append('=');
            result.append(AnnotationInvocationHandler.memberValueToString(e.getValue()));
        }
        result.append(')');
        return result.toString();
    }

    private static String memberValueToString(Object value) {
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            return value.toString();
        }
        if (type == byte[].class) {
            return Arrays.toString((byte[])value);
        }
        if (type == char[].class) {
            return Arrays.toString((char[])value);
        }
        if (type == double[].class) {
            return Arrays.toString((double[])value);
        }
        if (type == float[].class) {
            return Arrays.toString((float[])value);
        }
        if (type == int[].class) {
            return Arrays.toString((int[])value);
        }
        if (type == long[].class) {
            return Arrays.toString((long[])value);
        }
        if (type == short[].class) {
            return Arrays.toString((short[])value);
        }
        if (type == boolean[].class) {
            return Arrays.toString((boolean[])value);
        }
        return Arrays.toString((Object[])value);
    }

    private Boolean equalsImpl(Object o) {
        if (o == this) {
            return true;
        }
        if (!this.type.isInstance(o)) {
            return false;
        }
        for (Method memberMethod : this.getMemberMethods()) {
            String member = memberMethod.getName();
            Object ourValue = this.memberValues.get(member);
            Object hisValue = null;
            AnnotationInvocationHandler hisHandler = this.asOneOfUs(o);
            if (hisHandler != null) {
                hisValue = hisHandler.memberValues.get(member);
            } else {
                try {
                    hisValue = memberMethod.invoke(o, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    return false;
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (AnnotationInvocationHandler.memberValueEquals(ourValue, hisValue)) continue;
            return false;
        }
        return true;
    }

    private AnnotationInvocationHandler asOneOfUs(Object o) {
        InvocationHandler handler;
        if (Proxy.isProxyClass(o.getClass()) && (handler = Proxy.getInvocationHandler(o)) instanceof AnnotationInvocationHandler) {
            return (AnnotationInvocationHandler)handler;
        }
        return null;
    }

    private static boolean memberValueEquals(Object v1, Object v2) {
        Class<?> type = v1.getClass();
        if (!type.isArray()) {
            return v1.equals(v2);
        }
        if (v1 instanceof Object[] && v2 instanceof Object[]) {
            return Arrays.equals((Object[])v1, (Object[])v2);
        }
        if (v2.getClass() != type) {
            return false;
        }
        if (type == byte[].class) {
            return Arrays.equals((byte[])v1, (byte[])v2);
        }
        if (type == char[].class) {
            return Arrays.equals((char[])v1, (char[])v2);
        }
        if (type == double[].class) {
            return Arrays.equals((double[])v1, (double[])v2);
        }
        if (type == float[].class) {
            return Arrays.equals((float[])v1, (float[])v2);
        }
        if (type == int[].class) {
            return Arrays.equals((int[])v1, (int[])v2);
        }
        if (type == long[].class) {
            return Arrays.equals((long[])v1, (long[])v2);
        }
        if (type == short[].class) {
            return Arrays.equals((short[])v1, (short[])v2);
        }
        assert (type == boolean[].class);
        return Arrays.equals((boolean[])v1, (boolean[])v2);
    }

    private Method[] getMemberMethods() {
        if (this.memberMethods == null) {
            this.memberMethods = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                @Override
                public Method[] run() {
                    AccessibleObject[] mm = AnnotationInvocationHandler.this.type.getDeclaredMethods();
                    AnnotationInvocationHandler.this.validateAnnotationMethods((Method[])mm);
                    AccessibleObject.setAccessible(mm, true);
                    return mm;
                }
            });
        }
        return this.memberMethods;
    }

    private void validateAnnotationMethods(Method[] memberMethods) {
        boolean valid = true;
        for (Method method : memberMethods) {
            if (method.getModifiers() != 1025 || method.isDefault() || method.getParameterCount() != 0 || method.getExceptionTypes().length != 0) {
                valid = false;
                break;
            }
            Class<?> returnType = method.getReturnType();
            if (returnType.isArray() && (returnType = returnType.getComponentType()).isArray()) {
                valid = false;
                break;
            }
            if (!(returnType.isPrimitive() && returnType != Void.TYPE || returnType == String.class || returnType == Class.class || returnType.isEnum() || returnType.isAnnotation())) {
                valid = false;
                break;
            }
            String methodName = method.getName();
            if (!(methodName.equals("toString") && returnType == String.class || methodName.equals("hashCode") && returnType == Integer.TYPE) && (!methodName.equals("annotationType") || returnType != Class.class)) continue;
            valid = false;
            break;
        }
        if (valid) {
            return;
        }
        throw new AnnotationFormatError("Malformed method on an annotation type");
    }

    private int hashCodeImpl() {
        int result = 0;
        for (Map.Entry<String, Object> e : this.memberValues.entrySet()) {
            result += 127 * e.getKey().hashCode() ^ AnnotationInvocationHandler.memberValueHashCode(e.getValue());
        }
        return result;
    }

    private static int memberValueHashCode(Object value) {
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            return value.hashCode();
        }
        if (type == byte[].class) {
            return Arrays.hashCode((byte[])value);
        }
        if (type == char[].class) {
            return Arrays.hashCode((char[])value);
        }
        if (type == double[].class) {
            return Arrays.hashCode((double[])value);
        }
        if (type == float[].class) {
            return Arrays.hashCode((float[])value);
        }
        if (type == int[].class) {
            return Arrays.hashCode((int[])value);
        }
        if (type == long[].class) {
            return Arrays.hashCode((long[])value);
        }
        if (type == short[].class) {
            return Arrays.hashCode((short[])value);
        }
        if (type == boolean[].class) {
            return Arrays.hashCode((boolean[])value);
        }
        return Arrays.hashCode((Object[])value);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = s.readFields();
        Class t = (Class)fields.get("type", null);
        Map streamVals = (Map)fields.get("memberValues", null);
        AnnotationType annotationType = null;
        try {
            annotationType = AnnotationType.getInstance(t);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidObjectException("Non-annotation type in annotation serial stream");
        }
        Map<String, Class<?>> memberTypes = annotationType.memberTypes();
        LinkedHashMap<String, Object> mv = new LinkedHashMap<String, Object>();
        for (Map.Entry memberValue : streamVals.entrySet()) {
            String name = (String)memberValue.getKey();
            Object value = null;
            Class<?> memberType = memberTypes.get(name);
            if (memberType != null && !memberType.isInstance(value = (Object)memberValue.getValue()) && !(value instanceof ExceptionProxy)) {
                value = new AnnotationTypeMismatchExceptionProxy(value.getClass() + "[" + value + "]").setMember(annotationType.members().get(name));
            }
            mv.put(name, value);
        }
        UnsafeAccessor.setType(this, t);
        UnsafeAccessor.setMemberValues(this, mv);
    }

    private static class UnsafeAccessor {
        private static final Unsafe unsafe;
        private static final long typeOffset;
        private static final long memberValuesOffset;

        private UnsafeAccessor() {
        }

        static void setType(AnnotationInvocationHandler o, Class<? extends Annotation> type) {
            unsafe.putObject(o, typeOffset, type);
        }

        static void setMemberValues(AnnotationInvocationHandler o, Map<String, Object> memberValues) {
            unsafe.putObject(o, memberValuesOffset, memberValues);
        }

        static {
            try {
                unsafe = Unsafe.getUnsafe();
                typeOffset = unsafe.objectFieldOffset(AnnotationInvocationHandler.class.getDeclaredField("type"));
                memberValuesOffset = unsafe.objectFieldOffset(AnnotationInvocationHandler.class.getDeclaredField("memberValues"));
            }
            catch (Exception ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
    }
}

