/*
 * Decompiled with CFR 0.152.
 */
package ajava.beans.beancontext;

import ajava.beans.Beans;
import ajava.beans.PropertyChangeEvent;
import ajava.beans.PropertyChangeListener;
import ajava.beans.PropertyVetoException;
import ajava.beans.VetoableChangeListener;
import ajava.beans.Visibility;
import ajava.beans.beancontext.BeanContext;
import ajava.beans.beancontext.BeanContextChild;
import ajava.beans.beancontext.BeanContextChildSupport;
import ajava.beans.beancontext.BeanContextMembershipEvent;
import ajava.beans.beancontext.BeanContextMembershipListener;
import ajava.beans.beancontext.BeanContextProxy;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class BeanContextSupport
extends BeanContextChildSupport
implements BeanContext,
Serializable,
PropertyChangeListener,
VetoableChangeListener {
    static final long serialVersionUID = -4879613978649577204L;
    protected transient HashMap children;
    private int serializable = 0;
    protected transient ArrayList bcmListeners;
    protected Locale locale;
    protected boolean okToUseGui;
    protected boolean designTime;
    private transient PropertyChangeListener childPCL;
    private transient VetoableChangeListener childVCL;
    private transient boolean serializing;

    public BeanContextSupport(BeanContext peer, Locale lcle, boolean dTime, boolean visible) {
        super(peer);
        this.locale = lcle != null ? lcle : Locale.getDefault();
        this.designTime = dTime;
        this.okToUseGui = visible;
        this.initialize();
    }

    public BeanContextSupport(BeanContext peer, Locale lcle, boolean dtime) {
        this(peer, lcle, dtime, true);
    }

    public BeanContextSupport(BeanContext peer, Locale lcle) {
        this(peer, lcle, false, true);
    }

    public BeanContextSupport(BeanContext peer) {
        this(peer, null, false, true);
    }

    public BeanContextSupport() {
        this(null, null, false, true);
    }

    public BeanContext getBeanContextPeer() {
        return (BeanContext)this.getBeanContextChildPeer();
    }

    @Override
    public Object instantiateChild(String beanName) throws IOException, ClassNotFoundException {
        BeanContext bc = this.getBeanContextPeer();
        return Beans.instantiate(bc.getClass().getClassLoader(), beanName, bc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.containsKey(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object o) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.containsKey(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator iterator() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return new BCSIterator(this.children.keySet().iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.keySet().toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] arry) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.keySet().toArray(arry);
        }
    }

    protected BCSChild createBCSChild(Object targetChild, Object peer) {
        return new BCSChild(targetChild, peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object targetChild) {
        if (targetChild == null) {
            throw new IllegalArgumentException();
        }
        if (this.children.containsKey(targetChild)) {
            return false;
        }
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            Object[] objectArray;
            if (this.children.containsKey(targetChild)) {
                return false;
            }
            if (!this.validatePendingAdd(targetChild)) {
                throw new IllegalStateException();
            }
            BeanContextChild cbcc = BeanContextSupport.getChildBeanContextChild(targetChild);
            BeanContextChild bccp = null;
            Object object2 = targetChild;
            synchronized (object2) {
                Visibility v;
                if (targetChild instanceof BeanContextProxy && (bccp = ((BeanContextProxy)targetChild).getBeanContextProxy()) == null) {
                    throw new NullPointerException("BeanContextPeer.getBeanContextProxy()");
                }
                BCSChild bcsc = this.createBCSChild(targetChild, bccp);
                BCSChild pbcsc = null;
                Object object3 = this.children;
                synchronized (object3) {
                    this.children.put(targetChild, bcsc);
                    if (bccp != null) {
                        pbcsc = this.createBCSChild(bccp, targetChild);
                        this.children.put(bccp, pbcsc);
                    }
                }
                if (cbcc != null) {
                    object3 = cbcc;
                    synchronized (object3) {
                        try {
                            cbcc.setBeanContext(this.getBeanContextPeer());
                        }
                        catch (PropertyVetoException pve) {
                            HashMap hashMap = this.children;
                            synchronized (hashMap) {
                                this.children.remove(targetChild);
                                if (bccp != null) {
                                    this.children.remove(bccp);
                                }
                            }
                            throw new IllegalStateException();
                        }
                        cbcc.addPropertyChangeListener("beanContext", this.childPCL);
                        cbcc.addVetoableChangeListener("beanContext", this.childVCL);
                    }
                }
                if ((v = BeanContextSupport.getChildVisibility(targetChild)) != null) {
                    if (this.okToUseGui) {
                        v.okToUseGui();
                    } else {
                        v.dontUseGui();
                    }
                }
                if (BeanContextSupport.getChildSerializable(targetChild) != null) {
                    ++this.serializable;
                }
                this.childJustAddedHook(targetChild, bcsc);
                if (bccp != null) {
                    v = BeanContextSupport.getChildVisibility(bccp);
                    if (v != null) {
                        if (this.okToUseGui) {
                            v.okToUseGui();
                        } else {
                            v.dontUseGui();
                        }
                    }
                    if (BeanContextSupport.getChildSerializable(bccp) != null) {
                        ++this.serializable;
                    }
                    this.childJustAddedHook(bccp, pbcsc);
                }
            }
            BeanContext beanContext = this.getBeanContextPeer();
            if (bccp == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = targetChild;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = targetChild;
                objectArray = objectArray3;
                objectArray3[1] = bccp;
            }
            this.fireChildrenAdded(new BeanContextMembershipEvent(beanContext, objectArray));
        }
        return true;
    }

    @Override
    public boolean remove(Object targetChild) {
        return this.remove(targetChild, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean remove(Object targetChild, boolean callChildSetBC) {
        if (targetChild == null) {
            throw new IllegalArgumentException();
        }
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            Object[] objectArray;
            if (!this.containsKey(targetChild)) {
                return false;
            }
            if (!this.validatePendingRemove(targetChild)) {
                throw new IllegalStateException();
            }
            BCSChild bcsc = (BCSChild)this.children.get(targetChild);
            BCSChild pbcsc = null;
            Object peer = null;
            Object object2 = targetChild;
            synchronized (object2) {
                BeanContextChild cbcc;
                if (callChildSetBC && (cbcc = BeanContextSupport.getChildBeanContextChild(targetChild)) != null) {
                    BeanContextChild beanContextChild = cbcc;
                    synchronized (beanContextChild) {
                        cbcc.removePropertyChangeListener("beanContext", this.childPCL);
                        cbcc.removeVetoableChangeListener("beanContext", this.childVCL);
                        try {
                            cbcc.setBeanContext(null);
                        }
                        catch (PropertyVetoException pve1) {
                            cbcc.addPropertyChangeListener("beanContext", this.childPCL);
                            cbcc.addVetoableChangeListener("beanContext", this.childVCL);
                            throw new IllegalStateException();
                        }
                    }
                }
                HashMap hashMap = this.children;
                synchronized (hashMap) {
                    this.children.remove(targetChild);
                    if (bcsc.isProxyPeer()) {
                        peer = bcsc.getProxyPeer();
                        pbcsc = (BCSChild)this.children.get(peer);
                        this.children.remove(peer);
                    }
                }
                if (BeanContextSupport.getChildSerializable(targetChild) != null) {
                    --this.serializable;
                }
                this.childJustRemovedHook(targetChild, bcsc);
                if (peer != null) {
                    if (BeanContextSupport.getChildSerializable(peer) != null) {
                        --this.serializable;
                    }
                    this.childJustRemovedHook(peer, pbcsc);
                }
            }
            BeanContext beanContext = this.getBeanContextPeer();
            if (peer == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = targetChild;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = targetChild;
                objectArray = objectArray3;
                objectArray3[1] = peer;
            }
            this.fireChildrenRemoved(new BeanContextMembershipEvent(beanContext, objectArray));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection c) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            Iterator i = c.iterator();
            while (i.hasNext()) {
                if (this.contains(i.next())) continue;
                return false;
            }
            return true;
        }
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBeanContextMembershipListener(BeanContextMembershipListener bcml) {
        if (bcml == null) {
            throw new NullPointerException("listener");
        }
        ArrayList arrayList = this.bcmListeners;
        synchronized (arrayList) {
            if (this.bcmListeners.contains(bcml)) {
                return;
            }
            this.bcmListeners.add(bcml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBeanContextMembershipListener(BeanContextMembershipListener bcml) {
        if (bcml == null) {
            throw new NullPointerException("listener");
        }
        ArrayList arrayList = this.bcmListeners;
        synchronized (arrayList) {
            if (!this.bcmListeners.contains(bcml)) {
                return;
            }
            this.bcmListeners.remove(bcml);
        }
    }

    @Override
    public InputStream getResourceAsStream(String name, BeanContextChild bcc) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (bcc == null) {
            throw new NullPointerException("bcc");
        }
        if (this.containsKey(bcc)) {
            ClassLoader cl = bcc.getClass().getClassLoader();
            return cl != null ? cl.getResourceAsStream(name) : ClassLoader.getSystemResourceAsStream(name);
        }
        throw new IllegalArgumentException("Not a valid child");
    }

    @Override
    public URL getResource(String name, BeanContextChild bcc) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (bcc == null) {
            throw new NullPointerException("bcc");
        }
        if (this.containsKey(bcc)) {
            ClassLoader cl = bcc.getClass().getClassLoader();
            return cl != null ? cl.getResource(name) : ClassLoader.getSystemResource(name);
        }
        throw new IllegalArgumentException("Not a valid child");
    }

    @Override
    public synchronized void setDesignTime(boolean dTime) {
        if (this.designTime != dTime) {
            this.designTime = dTime;
            this.firePropertyChange("designMode", !dTime, dTime);
        }
    }

    @Override
    public synchronized boolean isDesignTime() {
        return this.designTime;
    }

    public synchronized void setLocale(Locale newLocale) throws PropertyVetoException {
        if (this.locale != null && !this.locale.equals(newLocale) && newLocale != null) {
            Locale old = this.locale;
            this.fireVetoableChange("locale", old, newLocale);
            this.locale = newLocale;
            this.firePropertyChange("locale", old, newLocale);
        }
    }

    public synchronized Locale getLocale() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean needsGui() {
        BeanContext bc = this.getBeanContextPeer();
        if (bc != this) {
            if (bc instanceof Visibility) {
                return bc.needsGui();
            }
            if (bc instanceof Container || bc instanceof Component) {
                return true;
            }
        }
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            for (Object c : this.children.keySet()) {
                try {
                    return ((Visibility)c).needsGui();
                }
                catch (ClassCastException classCastException) {
                    if (!(c instanceof Container) && !(c instanceof Component)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void dontUseGui() {
        if (this.okToUseGui) {
            this.okToUseGui = false;
            HashMap hashMap = this.children;
            synchronized (hashMap) {
                Iterator i = this.children.keySet().iterator();
                while (i.hasNext()) {
                    Visibility v = BeanContextSupport.getChildVisibility(i.next());
                    if (v == null) continue;
                    v.dontUseGui();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void okToUseGui() {
        if (!this.okToUseGui) {
            this.okToUseGui = true;
            HashMap hashMap = this.children;
            synchronized (hashMap) {
                Iterator i = this.children.keySet().iterator();
                while (i.hasNext()) {
                    Visibility v = BeanContextSupport.getChildVisibility(i.next());
                    if (v == null) continue;
                    v.okToUseGui();
                }
            }
        }
    }

    @Override
    public boolean avoidingGui() {
        return !this.okToUseGui && this.needsGui();
    }

    public boolean isSerializing() {
        return this.serializing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator bcsChildren() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.values().iterator();
        }
    }

    protected void bcsPreSerializationHook(ObjectOutputStream oos) throws IOException {
    }

    protected void bcsPreDeserializationHook(ObjectInputStream ois) throws IOException, ClassNotFoundException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void childDeserializedHook(Object child, BCSChild bcsc) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            this.children.put(child, bcsc);
        }
    }

    protected final void serialize(ObjectOutputStream oos, Collection coll) throws IOException {
        int i;
        int count = 0;
        Object[] objects = coll.toArray();
        for (i = 0; i < objects.length; ++i) {
            if (objects[i] instanceof Serializable) {
                ++count;
                continue;
            }
            objects[i] = null;
        }
        oos.writeInt(count);
        i = 0;
        while (count > 0) {
            Object o = objects[i];
            if (o != null) {
                oos.writeObject(o);
                --count;
            }
            ++i;
        }
    }

    protected final void deserialize(ObjectInputStream ois, Collection coll) throws IOException, ClassNotFoundException {
        int count = 0;
        count = ois.readInt();
        while (count-- > 0) {
            coll.add(ois.readObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeChildren(ObjectOutputStream oos) throws IOException {
        if (this.serializable <= 0) {
            return;
        }
        boolean prev = this.serializing;
        this.serializing = true;
        int count = 0;
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            Iterator i = this.children.entrySet().iterator();
            while (i.hasNext() && count < this.serializable) {
                Map.Entry entry = i.next();
                if (!(entry.getKey() instanceof Serializable)) continue;
                try {
                    oos.writeObject(entry.getKey());
                    oos.writeObject(entry.getValue());
                }
                catch (IOException ioe) {
                    this.serializing = prev;
                    throw ioe;
                }
                ++count;
            }
        }
        this.serializing = prev;
        if (count != this.serializable) {
            throw new IOException("wrote different number of children than expected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeObject(ObjectOutputStream oos) throws IOException, ClassNotFoundException {
        this.serializing = true;
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            try {
                oos.defaultWriteObject();
                this.bcsPreSerializationHook(oos);
                if (this.serializable > 0 && this.equals(this.getBeanContextPeer())) {
                    this.writeChildren(oos);
                }
                this.serialize(oos, this.bcmListeners);
            }
            finally {
                this.serializing = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void readChildren(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int count = this.serializable;
        while (count-- > 0) {
            Object child = null;
            BCSChild bscc = null;
            try {
                child = ois.readObject();
                bscc = (BCSChild)ois.readObject();
            }
            catch (IOException ioe) {
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                continue;
            }
            Object object = child;
            synchronized (object) {
                BeanContextChild bcc = null;
                try {
                    bcc = (BeanContextChild)child;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (bcc != null) {
                    try {
                        bcc.setBeanContext(this.getBeanContextPeer());
                        bcc.addPropertyChangeListener("beanContext", this.childPCL);
                        bcc.addVetoableChangeListener("beanContext", this.childVCL);
                    }
                    catch (PropertyVetoException pve) {
                        continue;
                    }
                }
                this.childDeserializedHook(child, bscc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            ois.defaultReadObject();
            this.initialize();
            this.bcsPreDeserializationHook(ois);
            if (this.serializable > 0 && this.equals(this.getBeanContextPeer())) {
                this.readChildren(ois);
            }
            this.bcmListeners = new ArrayList(1);
            this.deserialize(ois, this.bcmListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
        String propertyName = pce.getPropertyName();
        Object source = pce.getSource();
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            if ("beanContext".equals(propertyName) && this.containsKey(source) && !this.getBeanContextPeer().equals(pce.getNewValue())) {
                if (!this.validatePendingRemove(source)) {
                    throw new PropertyVetoException("current BeanContext vetoes setBeanContext()", pce);
                }
                ((BCSChild)this.children.get(source)).setRemovePending(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String propertyName = pce.getPropertyName();
        Object source = pce.getSource();
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            if ("beanContext".equals(propertyName) && this.containsKey(source) && ((BCSChild)this.children.get(source)).isRemovePending()) {
                BeanContext bc = this.getBeanContextPeer();
                if (bc.equals(pce.getOldValue()) && !bc.equals(pce.getNewValue())) {
                    this.remove(source, false);
                } else {
                    ((BCSChild)this.children.get(source)).setRemovePending(false);
                }
            }
        }
    }

    protected boolean validatePendingAdd(Object targetChild) {
        return true;
    }

    protected boolean validatePendingRemove(Object targetChild) {
        return true;
    }

    protected void childJustAddedHook(Object child, BCSChild bcsc) {
    }

    protected void childJustRemovedHook(Object child, BCSChild bcsc) {
    }

    protected static final Visibility getChildVisibility(Object child) {
        try {
            return (Visibility)child;
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    protected static final Serializable getChildSerializable(Object child) {
        try {
            return (Serializable)child;
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    protected static final PropertyChangeListener getChildPropertyChangeListener(Object child) {
        try {
            return (PropertyChangeListener)child;
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    protected static final VetoableChangeListener getChildVetoableChangeListener(Object child) {
        try {
            return (VetoableChangeListener)child;
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    protected static final BeanContextMembershipListener getChildBeanContextMembershipListener(Object child) {
        try {
            return (BeanContextMembershipListener)child;
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    protected static final BeanContextChild getChildBeanContextChild(Object child) {
        try {
            BeanContextChild bcc = (BeanContextChild)child;
            if (child instanceof BeanContextChild && child instanceof BeanContextProxy) {
                throw new IllegalArgumentException("child cannot implement both BeanContextChild and BeanContextProxy");
            }
            return bcc;
        }
        catch (ClassCastException cce) {
            try {
                return ((BeanContextProxy)child).getBeanContextProxy();
            }
            catch (ClassCastException cce1) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChildrenAdded(BeanContextMembershipEvent bcme) {
        Object[] copy;
        ArrayList arrayList = this.bcmListeners;
        synchronized (arrayList) {
            copy = this.bcmListeners.toArray();
        }
        for (int i = 0; i < copy.length; ++i) {
            ((BeanContextMembershipListener)copy[i]).childrenAdded(bcme);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChildrenRemoved(BeanContextMembershipEvent bcme) {
        Object[] copy;
        ArrayList arrayList = this.bcmListeners;
        synchronized (arrayList) {
            copy = this.bcmListeners.toArray();
        }
        for (int i = 0; i < copy.length; ++i) {
            ((BeanContextMembershipListener)copy[i]).childrenRemoved(bcme);
        }
    }

    protected synchronized void initialize() {
        this.children = new HashMap(this.serializable + 1);
        this.bcmListeners = new ArrayList(1);
        this.childPCL = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                BeanContextSupport.this.propertyChange(pce);
            }
        };
        this.childVCL = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
                BeanContextSupport.this.vetoableChange(pce);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object[] copyChildren() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.keySet().toArray();
        }
    }

    protected static final boolean classEquals(Class first, Class second) {
        return first.equals(second) || first.getName().equals(second.getName());
    }

    protected class BCSChild
    implements Serializable {
        private static final long serialVersionUID = -5815286101609939109L;
        private Object child;
        private Object proxyPeer;
        private transient boolean removePending;

        BCSChild(Object bcc, Object peer) {
            this.child = bcc;
            this.proxyPeer = peer;
        }

        Object getChild() {
            return this.child;
        }

        void setRemovePending(boolean v) {
            this.removePending = v;
        }

        boolean isRemovePending() {
            return this.removePending;
        }

        boolean isProxyPeer() {
            return this.proxyPeer != null;
        }

        Object getProxyPeer() {
            return this.proxyPeer;
        }
    }

    protected static final class BCSIterator
    implements Iterator {
        private Iterator src;

        BCSIterator(Iterator i) {
            this.src = i;
        }

        @Override
        public boolean hasNext() {
            return this.src.hasNext();
        }

        public Object next() {
            return this.src.next();
        }

        @Override
        public void remove() {
        }
    }
}

