/*
 * Decompiled with CFR 0.152.
 */
package ajava.beans;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

abstract class WeakIdentityMap<T> {
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final Object NULL = new Object();
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private volatile Entry<T>[] table = this.newTable(8);
    private int threshold = 6;
    private int size = 0;

    WeakIdentityMap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(Object key) {
        this.removeStaleEntries();
        if (key == null) {
            key = NULL;
        }
        int hash = key.hashCode();
        Entry<T>[] table = this.table;
        int index = WeakIdentityMap.getIndex(table, hash);
        Entry entry = table[index];
        while (entry != null) {
            if (entry.isMatched(key, hash)) {
                return (T)entry.value;
            }
            entry = entry.next;
        }
        Object object = NULL;
        synchronized (object) {
            index = WeakIdentityMap.getIndex(this.table, hash);
            Entry entry2 = this.table[index];
            while (entry2 != null) {
                if (entry2.isMatched(key, hash)) {
                    return (T)entry2.value;
                }
                entry2 = entry2.next;
            }
            T value = this.create(key);
            this.table[index] = new Entry<T>(key, hash, value, this.queue, this.table[index]);
            if (++this.size >= this.threshold) {
                if (this.table.length == 0x40000000) {
                    this.threshold = Integer.MAX_VALUE;
                } else {
                    this.removeStaleEntries();
                    table = this.newTable(this.table.length * 2);
                    this.transfer(this.table, table);
                    if (this.size >= this.threshold / 2) {
                        this.table = table;
                        this.threshold *= 2;
                    } else {
                        this.transfer(table, this.table);
                    }
                }
            }
            return value;
        }
    }

    protected abstract T create(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStaleEntries() {
        Reference<Object> ref = this.queue.poll();
        if (ref != null) {
            Object object = NULL;
            synchronized (object) {
                block3: do {
                    Entry prev;
                    Entry entry = (Entry)ref;
                    int index = WeakIdentityMap.getIndex(this.table, entry.hash);
                    Entry current = prev = this.table[index];
                    while (current != null) {
                        Entry next = current.next;
                        if (current == entry) {
                            if (prev == entry) {
                                this.table[index] = next;
                            } else {
                                prev.next = next;
                            }
                            entry.value = null;
                            entry.next = null;
                            --this.size;
                            continue block3;
                        }
                        prev = current;
                        current = next;
                    }
                } while ((ref = this.queue.poll()) != null);
            }
        }
    }

    private void transfer(Entry<T>[] oldTable, Entry<T>[] newTable) {
        for (int i = 0; i < oldTable.length; ++i) {
            Entry entry = oldTable[i];
            oldTable[i] = null;
            while (entry != null) {
                Entry next = entry.next;
                Object key = entry.get();
                if (key == null) {
                    entry.value = null;
                    entry.next = null;
                    --this.size;
                } else {
                    int index = WeakIdentityMap.getIndex(newTable, entry.hash);
                    entry.next = (Entry)newTable[index];
                    newTable[index] = entry;
                }
                entry = next;
            }
        }
    }

    private Entry<T>[] newTable(int length) {
        return new Entry[length];
    }

    private static int getIndex(Entry<?>[] table, int hash) {
        return hash & table.length - 1;
    }

    private static class Entry<T>
    extends WeakReference<Object> {
        private final int hash;
        private volatile T value;
        private volatile Entry<T> next;

        Entry(Object key, int hash, T value, ReferenceQueue<Object> queue, Entry<T> next) {
            super(key, queue);
            this.hash = hash;
            this.value = value;
            this.next = next;
        }

        boolean isMatched(Object key, int hash) {
            return this.hash == hash && key == this.get();
        }
    }
}

