/*
 * Decompiled with CFR 0.152.
 */
package im.delight.android.location;

import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import java.util.Random;

public class SimpleLocation {
    private static final String PROVIDER_COARSE = "network";
    private static final String PROVIDER_FINE = "gps";
    private static final String PROVIDER_FINE_PASSIVE = "passive";
    private static final long INTERVAL_DEFAULT = 600000L;
    private static final float KILOMETER_TO_METER = 1000.0f;
    private static final float LATITUDE_TO_KILOMETER = 111.133f;
    private static final float LONGITUDE_TO_KILOMETER_AT_ZERO_LATITUDE = 111.32f;
    private static final Random mRandom = new Random();
    private static final double SQUARE_ROOT_TWO = Math.sqrt(2.0);
    private static Location mCachedPosition;
    private final LocationManager mLocationManager;
    private final boolean mRequireFine;
    private final boolean mPassive;
    private final long mInterval;
    private final boolean mRequireNewLocation;
    private int mBlurRadius;
    private LocationListener mLocationListener;
    private Location mPosition;
    private Listener mListener;

    public SimpleLocation(Context context) {
        this(context, false);
    }

    public SimpleLocation(Context context, boolean requireFine) {
        this(context, requireFine, false);
    }

    public SimpleLocation(Context context, boolean requireFine, boolean passive) {
        this(context, requireFine, passive, 600000L);
    }

    public SimpleLocation(Context context, boolean requireFine, boolean passive, long interval) {
        this(context, requireFine, passive, interval, false);
    }

    public SimpleLocation(Context context, boolean requireFine, boolean passive, long interval, boolean requireNewLocation) {
        this.mLocationManager = (LocationManager)context.getApplicationContext().getSystemService("location");
        this.mRequireFine = requireFine;
        this.mPassive = passive;
        this.mInterval = interval;
        this.mRequireNewLocation = requireNewLocation;
        if (!this.mRequireNewLocation) {
            this.mPosition = this.getCachedPosition();
            this.cachePosition();
        }
    }

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    public boolean hasLocationEnabled() {
        return this.hasLocationEnabled(this.getProviderName());
    }

    private boolean hasLocationEnabled(String providerName) {
        try {
            return this.mLocationManager.isProviderEnabled(providerName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void beginUpdates() {
        if (this.mLocationListener != null) {
            this.endUpdates();
        }
        if (!this.mRequireNewLocation) {
            this.mPosition = this.getCachedPosition();
        }
        this.mLocationListener = this.createLocationListener();
        this.mLocationManager.requestLocationUpdates(this.getProviderName(), this.mInterval, 0.0f, this.mLocationListener);
    }

    public void endUpdates() {
        if (this.mLocationListener != null) {
            this.mLocationManager.removeUpdates(this.mLocationListener);
            this.mLocationListener = null;
        }
    }

    private Location blurWithRadius(Location originalLocation) {
        if (this.mBlurRadius <= 0) {
            return originalLocation;
        }
        Location newLocation = new Location(originalLocation);
        double blurMeterLong = (double)SimpleLocation.calculateRandomOffset(this.mBlurRadius) / SQUARE_ROOT_TWO;
        double blurMeterLat = (double)SimpleLocation.calculateRandomOffset(this.mBlurRadius) / SQUARE_ROOT_TWO;
        newLocation.setLongitude(newLocation.getLongitude() + SimpleLocation.meterToLongitude(blurMeterLong, newLocation.getLatitude()));
        newLocation.setLatitude(newLocation.getLatitude() + SimpleLocation.meterToLatitude(blurMeterLat));
        return newLocation;
    }

    private static int calculateRandomOffset(int radius) {
        return mRandom.nextInt((radius + 1) * 2) - radius;
    }

    public Point getPosition() {
        if (this.mPosition == null) {
            return null;
        }
        Location position = this.blurWithRadius(this.mPosition);
        return new Point(position.getLatitude(), position.getLongitude());
    }

    public double getLatitude() {
        if (this.mPosition == null) {
            return 0.0;
        }
        Location position = this.blurWithRadius(this.mPosition);
        return position.getLatitude();
    }

    public double getLongitude() {
        if (this.mPosition == null) {
            return 0.0;
        }
        Location position = this.blurWithRadius(this.mPosition);
        return position.getLongitude();
    }

    public long getTimestampInMilliseconds() {
        if (this.mPosition == null) {
            return 0L;
        }
        return this.mPosition.getTime();
    }

    public long getElapsedTimeInNanoseconds() {
        if (this.mPosition == null) {
            return 0L;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            return this.mPosition.getElapsedRealtimeNanos();
        }
        return (SystemClock.elapsedRealtime() + this.getTimestampInMilliseconds() - System.currentTimeMillis()) * 1000000L;
    }

    public float getSpeed() {
        if (this.mPosition == null) {
            return 0.0f;
        }
        return this.mPosition.getSpeed();
    }

    public double getAltitude() {
        if (this.mPosition == null) {
            return 0.0;
        }
        return this.mPosition.getAltitude();
    }

    public void setBlurRadius(int blurRadius) {
        this.mBlurRadius = blurRadius;
    }

    private LocationListener createLocationListener() {
        return new LocationListener(){

            public void onLocationChanged(Location location) {
                SimpleLocation.this.mPosition = location;
                SimpleLocation.this.cachePosition();
                if (SimpleLocation.this.mListener != null) {
                    SimpleLocation.this.mListener.onPositionChanged();
                }
            }

            public void onStatusChanged(String provider, int status, Bundle extras) {
            }

            public void onProviderEnabled(String provider) {
            }

            public void onProviderDisabled(String provider) {
            }
        };
    }

    private String getProviderName() {
        return this.getProviderName(this.mRequireFine);
    }

    private String getProviderName(boolean requireFine) {
        if (requireFine) {
            if (this.mPassive) {
                return PROVIDER_FINE_PASSIVE;
            }
            return PROVIDER_FINE;
        }
        if (this.hasLocationEnabled(PROVIDER_COARSE)) {
            if (this.mPassive) {
                throw new RuntimeException("There is no passive provider for the coarse location");
            }
            return PROVIDER_COARSE;
        }
        if (this.hasLocationEnabled(PROVIDER_FINE) || this.hasLocationEnabled(PROVIDER_FINE_PASSIVE)) {
            return this.getProviderName(true);
        }
        return PROVIDER_COARSE;
    }

    private Location getCachedPosition() {
        if (mCachedPosition != null) {
            return mCachedPosition;
        }
        try {
            return this.mLocationManager.getLastKnownLocation(this.getProviderName());
        }
        catch (Exception e) {
            return null;
        }
    }

    private void cachePosition() {
        if (this.mPosition != null) {
            mCachedPosition = this.mPosition;
        }
    }

    public static void openSettings(Context context) {
        context.startActivity(new Intent("android.settings.LOCATION_SOURCE_SETTINGS"));
    }

    public static double latitudeToKilometer(double latitude) {
        return latitude * (double)111.133f;
    }

    public static double kilometerToLatitude(double kilometer) {
        return kilometer / SimpleLocation.latitudeToKilometer(1.0);
    }

    public static double latitudeToMeter(double latitude) {
        return SimpleLocation.latitudeToKilometer(latitude) * 1000.0;
    }

    public static double meterToLatitude(double meter) {
        return meter / SimpleLocation.latitudeToMeter(1.0);
    }

    public static double longitudeToKilometer(double longitude, double latitude) {
        return longitude * (double)111.32f * Math.cos(Math.toRadians(latitude));
    }

    public static double kilometerToLongitude(double kilometer, double latitude) {
        return kilometer / SimpleLocation.longitudeToKilometer(1.0, latitude);
    }

    public static double longitudeToMeter(double longitude, double latitude) {
        return SimpleLocation.longitudeToKilometer(longitude, latitude) * 1000.0;
    }

    public static double meterToLongitude(double meter, double latitude) {
        return meter / SimpleLocation.longitudeToMeter(1.0, latitude);
    }

    public static double calculateDistance(Point start, Point end) {
        return SimpleLocation.calculateDistance(start.latitude, start.longitude, end.latitude, end.longitude);
    }

    public static double calculateDistance(double startLatitude, double startLongitude, double endLatitude, double endLongitude) {
        float[] results = new float[3];
        Location.distanceBetween((double)startLatitude, (double)startLongitude, (double)endLatitude, (double)endLongitude, (float[])results);
        return results[0];
    }

    public static interface Listener {
        public void onPositionChanged();
    }

    public static class Point
    implements Parcelable {
        public final double latitude;
        public final double longitude;
        public static final Parcelable.Creator<Point> CREATOR = new Parcelable.Creator<Point>(){

            public Point createFromParcel(Parcel in) {
                return new Point(in);
            }

            public Point[] newArray(int size) {
                return new Point[size];
            }
        };

        public Point(double lat, double lon) {
            this.latitude = lat;
            this.longitude = lon;
        }

        public String toString() {
            return "(" + this.latitude + ", " + this.longitude + ")";
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            out.writeDouble(this.latitude);
            out.writeDouble(this.longitude);
        }

        private Point(Parcel in) {
            this.latitude = in.readDouble();
            this.longitude = in.readDouble();
        }
    }
}

