/*
 * Decompiled with CFR 0.152.
 */
package im.delight.android.webview;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.DownloadManager;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Environment;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Base64;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ClientCertRequest;
import android.webkit.ConsoleMessage;
import android.webkit.CookieManager;
import android.webkit.DownloadListener;
import android.webkit.GeolocationPermissions;
import android.webkit.HttpAuthHandler;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.SslErrorHandler;
import android.webkit.URLUtil;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;

public class AdvancedWebView
extends WebView {
    public static final String PACKAGE_NAME_DOWNLOAD_MANAGER = "com.android.providers.downloads";
    protected static final int REQUEST_CODE_FILE_PICKER = 51426;
    protected static final String DATABASES_SUB_FOLDER = "/databases";
    protected static final String LANGUAGE_DEFAULT_ISO3 = "eng";
    protected static final String CHARSET_DEFAULT = "UTF-8";
    protected static final String[] ALTERNATIVE_BROWSERS = new String[]{"org.mozilla.firefox", "com.android.chrome", "com.opera.browser", "org.mozilla.firefox_beta", "com.chrome.beta", "com.opera.browser.beta"};
    protected WeakReference<Activity> mActivity;
    protected WeakReference<Fragment> mFragment;
    protected Listener mListener;
    protected final List<String> mPermittedHostnames = new LinkedList<String>();
    protected ValueCallback<Uri> mFileUploadCallbackFirst;
    protected ValueCallback<Uri[]> mFileUploadCallbackSecond;
    protected long mLastError;
    protected String mLanguageIso3;
    protected int mRequestCodeFilePicker = 51426;
    protected WebViewClient mCustomWebViewClient;
    protected WebChromeClient mCustomWebChromeClient;
    protected boolean mGeolocationEnabled;
    protected String mUploadableFileTypes = "*/*";
    protected final Map<String, String> mHttpHeaders = new HashMap<String, String>();

    public AdvancedWebView(Context context) {
        super(context);
        this.init(context);
    }

    public AdvancedWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AdvancedWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public void setListener(Activity activity, Listener listener) {
        this.setListener(activity, listener, 51426);
    }

    public void setListener(Activity activity, Listener listener, int requestCodeFilePicker) {
        this.mActivity = activity != null ? new WeakReference<Activity>(activity) : null;
        this.setListener(listener, requestCodeFilePicker);
    }

    public void setListener(Fragment fragment, Listener listener) {
        this.setListener(fragment, listener, 51426);
    }

    public void setListener(Fragment fragment, Listener listener, int requestCodeFilePicker) {
        this.mFragment = fragment != null ? new WeakReference<Fragment>(fragment) : null;
        this.setListener(listener, requestCodeFilePicker);
    }

    protected void setListener(Listener listener, int requestCodeFilePicker) {
        this.mListener = listener;
        this.mRequestCodeFilePicker = requestCodeFilePicker;
    }

    public void setWebViewClient(WebViewClient client) {
        this.mCustomWebViewClient = client;
    }

    public void setWebChromeClient(WebChromeClient client) {
        this.mCustomWebChromeClient = client;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void setGeolocationEnabled(boolean enabled) {
        if (enabled) {
            this.getSettings().setJavaScriptEnabled(true);
            this.getSettings().setGeolocationEnabled(true);
            this.setGeolocationDatabasePath();
        }
        this.mGeolocationEnabled = enabled;
    }

    @SuppressLint(value={"NewApi"})
    protected void setGeolocationDatabasePath() {
        Activity activity;
        if (this.mFragment != null && this.mFragment.get() != null && Build.VERSION.SDK_INT >= 11 && ((Fragment)this.mFragment.get()).getActivity() != null) {
            activity = ((Fragment)this.mFragment.get()).getActivity();
        } else if (this.mActivity != null && this.mActivity.get() != null) {
            activity = (Activity)this.mActivity.get();
        } else {
            return;
        }
        this.getSettings().setGeolocationDatabasePath(activity.getFilesDir().getPath());
    }

    public void setUploadableFileTypes(String mimeType) {
        this.mUploadableFileTypes = mimeType;
    }

    public void loadHtml(String html) {
        this.loadHtml(html, null);
    }

    public void loadHtml(String html, String baseUrl) {
        this.loadHtml(html, baseUrl, null);
    }

    public void loadHtml(String html, String baseUrl, String historyUrl) {
        this.loadHtml(html, baseUrl, historyUrl, "utf-8");
    }

    public void loadHtml(String html, String baseUrl, String historyUrl, String encoding) {
        this.loadDataWithBaseURL(baseUrl, html, "text/html", encoding, historyUrl);
    }

    @SuppressLint(value={"NewApi"})
    public void onResume() {
        if (Build.VERSION.SDK_INT >= 11) {
            super.onResume();
        }
        this.resumeTimers();
    }

    @SuppressLint(value={"NewApi"})
    public void onPause() {
        this.pauseTimers();
        if (Build.VERSION.SDK_INT >= 11) {
            super.onPause();
        }
    }

    public void onDestroy() {
        try {
            ((ViewGroup)this.getParent()).removeView((View)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.removeAllViews();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.destroy();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        if (requestCode == this.mRequestCodeFilePicker) {
            if (resultCode == -1) {
                if (intent != null) {
                    if (this.mFileUploadCallbackFirst != null) {
                        this.mFileUploadCallbackFirst.onReceiveValue((Object)intent.getData());
                        this.mFileUploadCallbackFirst = null;
                    } else if (this.mFileUploadCallbackSecond != null) {
                        Uri[] dataUris = null;
                        try {
                            if (intent.getDataString() != null) {
                                dataUris = new Uri[]{Uri.parse((String)intent.getDataString())};
                            } else if (Build.VERSION.SDK_INT >= 16 && intent.getClipData() != null) {
                                int numSelectedFiles = intent.getClipData().getItemCount();
                                dataUris = new Uri[numSelectedFiles];
                                for (int i = 0; i < numSelectedFiles; ++i) {
                                    dataUris[i] = intent.getClipData().getItemAt(i).getUri();
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.mFileUploadCallbackSecond.onReceiveValue(dataUris);
                        this.mFileUploadCallbackSecond = null;
                    }
                }
            } else if (this.mFileUploadCallbackFirst != null) {
                this.mFileUploadCallbackFirst.onReceiveValue(null);
                this.mFileUploadCallbackFirst = null;
            } else if (this.mFileUploadCallbackSecond != null) {
                this.mFileUploadCallbackSecond.onReceiveValue(null);
                this.mFileUploadCallbackSecond = null;
            }
        }
    }

    public void addHttpHeader(String name, String value) {
        this.mHttpHeaders.put(name, value);
    }

    public void removeHttpHeader(String name) {
        this.mHttpHeaders.remove(name);
    }

    public void addPermittedHostname(String hostname) {
        this.mPermittedHostnames.add(hostname);
    }

    public void addPermittedHostnames(Collection<? extends String> collection) {
        this.mPermittedHostnames.addAll(collection);
    }

    public List<String> getPermittedHostnames() {
        return this.mPermittedHostnames;
    }

    public void removePermittedHostname(String hostname) {
        this.mPermittedHostnames.remove(hostname);
    }

    public void clearPermittedHostnames() {
        this.mPermittedHostnames.clear();
    }

    public boolean onBackPressed() {
        if (this.canGoBack()) {
            this.goBack();
            return false;
        }
        return true;
    }

    @SuppressLint(value={"NewApi"})
    protected static void setAllowAccessFromFileUrls(WebSettings webSettings, boolean allowed) {
        if (Build.VERSION.SDK_INT >= 16) {
            webSettings.setAllowFileAccessFromFileURLs(allowed);
            webSettings.setAllowUniversalAccessFromFileURLs(allowed);
        }
    }

    public void setCookiesEnabled(boolean enabled) {
        CookieManager.getInstance().setAcceptCookie(enabled);
    }

    @SuppressLint(value={"NewApi"})
    public void setThirdPartyCookiesEnabled(boolean enabled) {
        if (Build.VERSION.SDK_INT >= 21) {
            CookieManager.getInstance().setAcceptThirdPartyCookies((WebView)this, enabled);
        }
    }

    public void setMixedContentAllowed(boolean allowed) {
        this.setMixedContentAllowed(this.getSettings(), allowed);
    }

    @SuppressLint(value={"NewApi"})
    protected void setMixedContentAllowed(WebSettings webSettings, boolean allowed) {
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(allowed ? 0 : 1);
        }
    }

    public void setDesktopMode(boolean enabled) {
        WebSettings webSettings = this.getSettings();
        String newUserAgent = enabled ? webSettings.getUserAgentString().replace("Mobile", "eliboM").replace("Android", "diordnA") : webSettings.getUserAgentString().replace("eliboM", "Mobile").replace("diordnA", "Android");
        webSettings.setUserAgentString(newUserAgent);
        webSettings.setUseWideViewPort(enabled);
        webSettings.setLoadWithOverviewMode(enabled);
        webSettings.setSupportZoom(enabled);
        webSettings.setBuiltInZoomControls(enabled);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void init(Context context) {
        if (this.isInEditMode()) {
            return;
        }
        if (context instanceof Activity) {
            this.mActivity = new WeakReference<Activity>((Activity)context);
        }
        this.mLanguageIso3 = AdvancedWebView.getLanguageIso3();
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setSaveEnabled(true);
        String filesDir = context.getFilesDir().getPath();
        String databaseDir = filesDir.substring(0, filesDir.lastIndexOf("/")) + DATABASES_SUB_FOLDER;
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        AdvancedWebView.setAllowAccessFromFileUrls(webSettings, false);
        webSettings.setBuiltInZoomControls(false);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setDomStorageEnabled(true);
        if (Build.VERSION.SDK_INT < 18) {
            webSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);
        }
        webSettings.setDatabaseEnabled(true);
        if (Build.VERSION.SDK_INT < 19) {
            webSettings.setDatabasePath(databaseDir);
        }
        this.setMixedContentAllowed(webSettings, true);
        this.setThirdPartyCookiesEnabled(true);
        super.setWebViewClient(new WebViewClient(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                if (!AdvancedWebView.this.hasError() && AdvancedWebView.this.mListener != null) {
                    AdvancedWebView.this.mListener.onPageStarted(url, favicon);
                }
                if (AdvancedWebView.this.mCustomWebViewClient != null) {
                    AdvancedWebView.this.mCustomWebViewClient.onPageStarted(view, url, favicon);
                }
            }

            public void onPageFinished(WebView view, String url) {
                if (!AdvancedWebView.this.hasError() && AdvancedWebView.this.mListener != null) {
                    AdvancedWebView.this.mListener.onPageFinished(url);
                }
                if (AdvancedWebView.this.mCustomWebViewClient != null) {
                    AdvancedWebView.this.mCustomWebViewClient.onPageFinished(view, url);
                }
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                AdvancedWebView.this.setLastError();
                if (AdvancedWebView.this.mListener != null) {
                    AdvancedWebView.this.mListener.onPageError(errorCode, description, failingUrl);
                }
                if (AdvancedWebView.this.mCustomWebViewClient != null) {
                    AdvancedWebView.this.mCustomWebViewClient.onReceivedError(view, errorCode, description, failingUrl);
                }
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (!AdvancedWebView.this.isPermittedUrl(url)) {
                    if (AdvancedWebView.this.mListener != null) {
                        AdvancedWebView.this.mListener.onExternalPageRequest(url);
                    }
                    return true;
                }
                if (AdvancedWebView.this.mCustomWebViewClient != null && AdvancedWebView.this.mCustomWebViewClient.shouldOverrideUrlLoading(view, url)) {
                    return true;
                }
                view.loadUrl(url);
                return true;
            }

            public void onLoadResource(WebView view, String url) {
                if (AdvancedWebView.this.mCustomWebViewClient != null) {
                    AdvancedWebView.this.mCustomWebViewClient.onLoadResource(view, url);
                } else {
                    super.onLoadResource(view, url);
                }
            }

            @SuppressLint(value={"NewApi"})
            public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
                if (Build.VERSION.SDK_INT >= 11) {
                    if (AdvancedWebView.this.mCustomWebViewClient != null) {
                        return AdvancedWebView.this.mCustomWebViewClient.shouldInterceptRequest(view, url);
                    }
                    return super.shouldInterceptRequest(view, url);
                }
                return null;
            }

            @SuppressLint(value={"NewApi"})
            public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
                if (Build.VERSION.SDK_INT >= 21) {
                    if (AdvancedWebView.this.mCustomWebViewClient != null) {
                        return AdvancedWebView.this.mCustomWebViewClient.shouldInterceptRequest(view, request);
                    }
                    return super.shouldInterceptRequest(view, request);
                }
                return null;
            }

            public void onFormResubmission(WebView view, Message dontResend, Message resend) {
                if (AdvancedWebView.this.mCustomWebViewClient != null) {
                    AdvancedWebView.this.mCustomWebViewClient.onFormResubmission(view, dontResend, resend);
                } else {
                    super.onFormResubmission(view, dontResend, resend);
                }
            }

            public void doUpdateVisitedHistory(WebView view, String url, boolean isReload) {
                if (AdvancedWebView.this.mCustomWebViewClient != null) {
                    AdvancedWebView.this.mCustomWebViewClient.doUpdateVisitedHistory(view, url, isReload);
                } else {
                    super.doUpdateVisitedHistory(view, url, isReload);
                }
            }

            public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                if (AdvancedWebView.this.mCustomWebViewClient != null) {
                    AdvancedWebView.this.mCustomWebViewClient.onReceivedSslError(view, handler, error);
                } else {
                    super.onReceivedSslError(view, handler, error);
                }
            }

            @SuppressLint(value={"NewApi"})
            public void onReceivedClientCertRequest(WebView view, ClientCertRequest request) {
                if (Build.VERSION.SDK_INT >= 21) {
                    if (AdvancedWebView.this.mCustomWebViewClient != null) {
                        AdvancedWebView.this.mCustomWebViewClient.onReceivedClientCertRequest(view, request);
                    } else {
                        super.onReceivedClientCertRequest(view, request);
                    }
                }
            }

            public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
                if (AdvancedWebView.this.mCustomWebViewClient != null) {
                    AdvancedWebView.this.mCustomWebViewClient.onReceivedHttpAuthRequest(view, handler, host, realm);
                } else {
                    super.onReceivedHttpAuthRequest(view, handler, host, realm);
                }
            }

            public boolean shouldOverrideKeyEvent(WebView view, KeyEvent event) {
                if (AdvancedWebView.this.mCustomWebViewClient != null) {
                    return AdvancedWebView.this.mCustomWebViewClient.shouldOverrideKeyEvent(view, event);
                }
                return super.shouldOverrideKeyEvent(view, event);
            }

            public void onUnhandledKeyEvent(WebView view, KeyEvent event) {
                if (AdvancedWebView.this.mCustomWebViewClient != null) {
                    AdvancedWebView.this.mCustomWebViewClient.onUnhandledKeyEvent(view, event);
                } else {
                    super.onUnhandledKeyEvent(view, event);
                }
            }

            @SuppressLint(value={"NewApi"})
            public void onUnhandledInputEvent(WebView view, InputEvent event) {
                if (Build.VERSION.SDK_INT >= 21) {
                    if (AdvancedWebView.this.mCustomWebViewClient != null) {
                        AdvancedWebView.this.mCustomWebViewClient.onUnhandledInputEvent(view, event);
                    } else {
                        super.onUnhandledInputEvent(view, event);
                    }
                }
            }

            public void onScaleChanged(WebView view, float oldScale, float newScale) {
                if (AdvancedWebView.this.mCustomWebViewClient != null) {
                    AdvancedWebView.this.mCustomWebViewClient.onScaleChanged(view, oldScale, newScale);
                } else {
                    super.onScaleChanged(view, oldScale, newScale);
                }
            }

            @SuppressLint(value={"NewApi"})
            public void onReceivedLoginRequest(WebView view, String realm, String account, String args) {
                if (Build.VERSION.SDK_INT >= 12) {
                    if (AdvancedWebView.this.mCustomWebViewClient != null) {
                        AdvancedWebView.this.mCustomWebViewClient.onReceivedLoginRequest(view, realm, account, args);
                    } else {
                        super.onReceivedLoginRequest(view, realm, account, args);
                    }
                }
            }
        });
        super.setWebChromeClient(new WebChromeClient(){

            public void openFileChooser(ValueCallback<Uri> uploadMsg) {
                this.openFileChooser(uploadMsg, null);
            }

            public void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType) {
                this.openFileChooser(uploadMsg, acceptType, null);
            }

            public void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType, String capture) {
                AdvancedWebView.this.openFileInput(uploadMsg, null, false);
            }

            public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
                if (Build.VERSION.SDK_INT >= 21) {
                    boolean allowMultiple = fileChooserParams.getMode() == 1;
                    AdvancedWebView.this.openFileInput(null, filePathCallback, allowMultiple);
                    return true;
                }
                return false;
            }

            public void onProgressChanged(WebView view, int newProgress) {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    AdvancedWebView.this.mCustomWebChromeClient.onProgressChanged(view, newProgress);
                } else {
                    super.onProgressChanged(view, newProgress);
                }
            }

            public void onReceivedTitle(WebView view, String title) {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    AdvancedWebView.this.mCustomWebChromeClient.onReceivedTitle(view, title);
                } else {
                    super.onReceivedTitle(view, title);
                }
            }

            public void onReceivedIcon(WebView view, Bitmap icon) {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    AdvancedWebView.this.mCustomWebChromeClient.onReceivedIcon(view, icon);
                } else {
                    super.onReceivedIcon(view, icon);
                }
            }

            public void onReceivedTouchIconUrl(WebView view, String url, boolean precomposed) {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    AdvancedWebView.this.mCustomWebChromeClient.onReceivedTouchIconUrl(view, url, precomposed);
                } else {
                    super.onReceivedTouchIconUrl(view, url, precomposed);
                }
            }

            public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    AdvancedWebView.this.mCustomWebChromeClient.onShowCustomView(view, callback);
                } else {
                    super.onShowCustomView(view, callback);
                }
            }

            @SuppressLint(value={"NewApi"})
            public void onShowCustomView(View view, int requestedOrientation, WebChromeClient.CustomViewCallback callback) {
                if (Build.VERSION.SDK_INT >= 14) {
                    if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                        AdvancedWebView.this.mCustomWebChromeClient.onShowCustomView(view, requestedOrientation, callback);
                    } else {
                        super.onShowCustomView(view, requestedOrientation, callback);
                    }
                }
            }

            public void onHideCustomView() {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    AdvancedWebView.this.mCustomWebChromeClient.onHideCustomView();
                } else {
                    super.onHideCustomView();
                }
            }

            public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    return AdvancedWebView.this.mCustomWebChromeClient.onCreateWindow(view, isDialog, isUserGesture, resultMsg);
                }
                return super.onCreateWindow(view, isDialog, isUserGesture, resultMsg);
            }

            public void onRequestFocus(WebView view) {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    AdvancedWebView.this.mCustomWebChromeClient.onRequestFocus(view);
                } else {
                    super.onRequestFocus(view);
                }
            }

            public void onCloseWindow(WebView window) {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    AdvancedWebView.this.mCustomWebChromeClient.onCloseWindow(window);
                } else {
                    super.onCloseWindow(window);
                }
            }

            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    return AdvancedWebView.this.mCustomWebChromeClient.onJsAlert(view, url, message, result);
                }
                return super.onJsAlert(view, url, message, result);
            }

            public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    return AdvancedWebView.this.mCustomWebChromeClient.onJsConfirm(view, url, message, result);
                }
                return super.onJsConfirm(view, url, message, result);
            }

            public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    return AdvancedWebView.this.mCustomWebChromeClient.onJsPrompt(view, url, message, defaultValue, result);
                }
                return super.onJsPrompt(view, url, message, defaultValue, result);
            }

            public boolean onJsBeforeUnload(WebView view, String url, String message, JsResult result) {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    return AdvancedWebView.this.mCustomWebChromeClient.onJsBeforeUnload(view, url, message, result);
                }
                return super.onJsBeforeUnload(view, url, message, result);
            }

            public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
                if (AdvancedWebView.this.mGeolocationEnabled) {
                    callback.invoke(origin, true, false);
                } else if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    AdvancedWebView.this.mCustomWebChromeClient.onGeolocationPermissionsShowPrompt(origin, callback);
                } else {
                    super.onGeolocationPermissionsShowPrompt(origin, callback);
                }
            }

            public void onGeolocationPermissionsHidePrompt() {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    AdvancedWebView.this.mCustomWebChromeClient.onGeolocationPermissionsHidePrompt();
                } else {
                    super.onGeolocationPermissionsHidePrompt();
                }
            }

            @SuppressLint(value={"NewApi"})
            public void onPermissionRequest(PermissionRequest request) {
                if (Build.VERSION.SDK_INT >= 21) {
                    if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                        AdvancedWebView.this.mCustomWebChromeClient.onPermissionRequest(request);
                    } else {
                        super.onPermissionRequest(request);
                    }
                }
            }

            @SuppressLint(value={"NewApi"})
            public void onPermissionRequestCanceled(PermissionRequest request) {
                if (Build.VERSION.SDK_INT >= 21) {
                    if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                        AdvancedWebView.this.mCustomWebChromeClient.onPermissionRequestCanceled(request);
                    } else {
                        super.onPermissionRequestCanceled(request);
                    }
                }
            }

            public boolean onJsTimeout() {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    return AdvancedWebView.this.mCustomWebChromeClient.onJsTimeout();
                }
                return super.onJsTimeout();
            }

            public void onConsoleMessage(String message, int lineNumber, String sourceID) {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    AdvancedWebView.this.mCustomWebChromeClient.onConsoleMessage(message, lineNumber, sourceID);
                } else {
                    super.onConsoleMessage(message, lineNumber, sourceID);
                }
            }

            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    return AdvancedWebView.this.mCustomWebChromeClient.onConsoleMessage(consoleMessage);
                }
                return super.onConsoleMessage(consoleMessage);
            }

            public Bitmap getDefaultVideoPoster() {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    return AdvancedWebView.this.mCustomWebChromeClient.getDefaultVideoPoster();
                }
                return super.getDefaultVideoPoster();
            }

            public View getVideoLoadingProgressView() {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    return AdvancedWebView.this.mCustomWebChromeClient.getVideoLoadingProgressView();
                }
                return super.getVideoLoadingProgressView();
            }

            public void getVisitedHistory(ValueCallback<String[]> callback) {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    AdvancedWebView.this.mCustomWebChromeClient.getVisitedHistory(callback);
                } else {
                    super.getVisitedHistory(callback);
                }
            }

            public void onExceededDatabaseQuota(String url, String databaseIdentifier, long quota, long estimatedDatabaseSize, long totalQuota, WebStorage.QuotaUpdater quotaUpdater) {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    AdvancedWebView.this.mCustomWebChromeClient.onExceededDatabaseQuota(url, databaseIdentifier, quota, estimatedDatabaseSize, totalQuota, quotaUpdater);
                } else {
                    super.onExceededDatabaseQuota(url, databaseIdentifier, quota, estimatedDatabaseSize, totalQuota, quotaUpdater);
                }
            }

            public void onReachedMaxAppCacheSize(long requiredStorage, long quota, WebStorage.QuotaUpdater quotaUpdater) {
                if (AdvancedWebView.this.mCustomWebChromeClient != null) {
                    AdvancedWebView.this.mCustomWebChromeClient.onReachedMaxAppCacheSize(requiredStorage, quota, quotaUpdater);
                } else {
                    super.onReachedMaxAppCacheSize(requiredStorage, quota, quotaUpdater);
                }
            }
        });
        this.setDownloadListener(new DownloadListener(){

            public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long contentLength) {
                String suggestedFilename = URLUtil.guessFileName((String)url, (String)contentDisposition, (String)mimeType);
                if (AdvancedWebView.this.mListener != null) {
                    AdvancedWebView.this.mListener.onDownloadRequested(url, suggestedFilename, mimeType, contentLength, contentDisposition, userAgent);
                }
            }
        });
    }

    public void loadUrl(String url, Map<String, String> additionalHttpHeaders) {
        if (additionalHttpHeaders == null) {
            additionalHttpHeaders = this.mHttpHeaders;
        } else if (this.mHttpHeaders.size() > 0) {
            additionalHttpHeaders.putAll(this.mHttpHeaders);
        }
        super.loadUrl(url, additionalHttpHeaders);
    }

    public void loadUrl(String url) {
        if (this.mHttpHeaders.size() > 0) {
            super.loadUrl(url, this.mHttpHeaders);
        } else {
            super.loadUrl(url);
        }
    }

    public void loadUrl(String url, boolean preventCaching) {
        if (preventCaching) {
            url = AdvancedWebView.makeUrlUnique(url);
        }
        this.loadUrl(url);
    }

    public void loadUrl(String url, boolean preventCaching, Map<String, String> additionalHttpHeaders) {
        if (preventCaching) {
            url = AdvancedWebView.makeUrlUnique(url);
        }
        this.loadUrl(url, additionalHttpHeaders);
    }

    protected static String makeUrlUnique(String url) {
        StringBuilder unique = new StringBuilder();
        unique.append(url);
        if (url.contains("?")) {
            unique.append('&');
        } else {
            if (url.lastIndexOf(47) <= 7) {
                unique.append('/');
            }
            unique.append('?');
        }
        unique.append(System.currentTimeMillis());
        unique.append('=');
        unique.append(1);
        return unique.toString();
    }

    public boolean isPermittedUrl(String url) {
        if (this.mPermittedHostnames.size() == 0) {
            return true;
        }
        String actualHost = Uri.parse((String)url).getHost();
        if (actualHost == null) {
            return false;
        }
        for (String expectedHost : this.mPermittedHostnames) {
            if (!actualHost.equals(expectedHost) && !actualHost.endsWith("." + expectedHost)) continue;
            return true;
        }
        return false;
    }

    protected boolean isHostnameAllowed(String url) {
        return this.isPermittedUrl(url);
    }

    protected void setLastError() {
        this.mLastError = System.currentTimeMillis();
    }

    protected boolean hasError() {
        return this.mLastError + 500L >= System.currentTimeMillis();
    }

    protected static String getLanguageIso3() {
        try {
            return Locale.getDefault().getISO3Language().toLowerCase(Locale.US);
        }
        catch (MissingResourceException e) {
            return LANGUAGE_DEFAULT_ISO3;
        }
    }

    protected String getFileUploadPromptLabel() {
        try {
            if (this.mLanguageIso3.equals("zho")) {
                return AdvancedWebView.decodeBase64("6YCJ5oup5LiA5Liq5paH5Lu2");
            }
            if (this.mLanguageIso3.equals("spa")) {
                return AdvancedWebView.decodeBase64("RWxpamEgdW4gYXJjaGl2bw==");
            }
            if (this.mLanguageIso3.equals("hin")) {
                return AdvancedWebView.decodeBase64("4KSP4KSVIOCkq+CkvOCkvuCkh+CksiDgpJrgpYHgpKjgpYfgpII=");
            }
            if (this.mLanguageIso3.equals("ben")) {
                return AdvancedWebView.decodeBase64("4KaP4KaV4Kaf4Ka/IOCmq+CmvuCmh+CmsiDgpqjgpr/gprDgp43gpqzgpr7gpprgpqg=");
            }
            if (this.mLanguageIso3.equals("ara")) {
                return AdvancedWebView.decodeBase64("2KfYrtiq2YrYp9ixINmF2YTZgSDZiNin2K3Yrw==");
            }
            if (this.mLanguageIso3.equals("por")) {
                return AdvancedWebView.decodeBase64("RXNjb2xoYSB1bSBhcnF1aXZv");
            }
            if (this.mLanguageIso3.equals("rus")) {
                return AdvancedWebView.decodeBase64("0JLRi9Cx0LXRgNC40YLQtSDQvtC00LjQvSDRhNCw0LnQuw==");
            }
            if (this.mLanguageIso3.equals("jpn")) {
                return AdvancedWebView.decodeBase64("MeODleOCoeOCpOODq+OCkumBuOaKnuOBl+OBpuOBj+OBoOOBleOBhA==");
            }
            if (this.mLanguageIso3.equals("pan")) {
                return AdvancedWebView.decodeBase64("4KiH4Kmx4KiVIOCoq+CovuCoh+CosiDgqJrgqYHgqKPgqYs=");
            }
            if (this.mLanguageIso3.equals("deu")) {
                return AdvancedWebView.decodeBase64("V8OkaGxlIGVpbmUgRGF0ZWk=");
            }
            if (this.mLanguageIso3.equals("jav")) {
                return AdvancedWebView.decodeBase64("UGlsaWggc2lqaSBiZXJrYXM=");
            }
            if (this.mLanguageIso3.equals("msa")) {
                return AdvancedWebView.decodeBase64("UGlsaWggc2F0dSBmYWls");
            }
            if (this.mLanguageIso3.equals("tel")) {
                return AdvancedWebView.decodeBase64("4LCS4LCVIOCwq+CxhuCxluCwsuCxjeCwqOCxgSDgsI7gsILgsJrgsYHgsJXgsYvgsILgsKHgsL8=");
            }
            if (this.mLanguageIso3.equals("vie")) {
                return AdvancedWebView.decodeBase64("Q2jhu41uIG3hu5l0IHThuq1wIHRpbg==");
            }
            if (this.mLanguageIso3.equals("kor")) {
                return AdvancedWebView.decodeBase64("7ZWY64KY7J2YIO2MjOydvOydhCDshKDtg50=");
            }
            if (this.mLanguageIso3.equals("fra")) {
                return AdvancedWebView.decodeBase64("Q2hvaXNpc3NleiB1biBmaWNoaWVy");
            }
            if (this.mLanguageIso3.equals("mar")) {
                return AdvancedWebView.decodeBase64("4KSr4KS+4KSH4KSyIOCkqOCkv+CkteCkoeCkvg==");
            }
            if (this.mLanguageIso3.equals("tam")) {
                return AdvancedWebView.decodeBase64("4K6S4K6w4K+BIOCuleCvh+CuvuCuquCvjeCuquCviCDgrqTgr4fgrrDgr43grrXgr4E=");
            }
            if (this.mLanguageIso3.equals("urd")) {
                return AdvancedWebView.decodeBase64("2KfbjNqpINmB2KfYptmEINmF24zauiDYs9uSINin2YbYqtiu2KfYqCDaqdix24zaug==");
            }
            if (this.mLanguageIso3.equals("fas")) {
                return AdvancedWebView.decodeBase64("2LHYpyDYp9mG2KrYrtin2Kgg2qnZhtuM2K8g24zaqSDZgdin24zZhA==");
            }
            if (this.mLanguageIso3.equals("tur")) {
                return AdvancedWebView.decodeBase64("QmlyIGRvc3lhIHNlw6dpbg==");
            }
            if (this.mLanguageIso3.equals("ita")) {
                return AdvancedWebView.decodeBase64("U2NlZ2xpIHVuIGZpbGU=");
            }
            if (this.mLanguageIso3.equals("tha")) {
                return AdvancedWebView.decodeBase64("4LmA4Lil4Li34Lit4LiB4LmE4Lif4Lil4LmM4Lir4LiZ4Li24LmI4LiH");
            }
            if (this.mLanguageIso3.equals("guj")) {
                return AdvancedWebView.decodeBase64("4KqP4KqVIOCqq+CqvuCqh+CqsuCqqOCrhyDgqqrgqrjgqoLgqqY=");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "Choose a file";
    }

    protected static String decodeBase64(String base64) throws IllegalArgumentException, UnsupportedEncodingException {
        byte[] bytes = Base64.decode((String)base64, (int)0);
        return new String(bytes, CHARSET_DEFAULT);
    }

    @SuppressLint(value={"NewApi"})
    protected void openFileInput(ValueCallback<Uri> fileUploadCallbackFirst, ValueCallback<Uri[]> fileUploadCallbackSecond, boolean allowMultiple) {
        if (this.mFileUploadCallbackFirst != null) {
            this.mFileUploadCallbackFirst.onReceiveValue(null);
        }
        this.mFileUploadCallbackFirst = fileUploadCallbackFirst;
        if (this.mFileUploadCallbackSecond != null) {
            this.mFileUploadCallbackSecond.onReceiveValue(null);
        }
        this.mFileUploadCallbackSecond = fileUploadCallbackSecond;
        Intent i = new Intent("android.intent.action.GET_CONTENT");
        i.addCategory("android.intent.category.OPENABLE");
        if (allowMultiple && Build.VERSION.SDK_INT >= 18) {
            i.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
        }
        i.setType(this.mUploadableFileTypes);
        if (this.mFragment != null && this.mFragment.get() != null && Build.VERSION.SDK_INT >= 11) {
            ((Fragment)this.mFragment.get()).startActivityForResult(Intent.createChooser((Intent)i, (CharSequence)this.getFileUploadPromptLabel()), this.mRequestCodeFilePicker);
        } else if (this.mActivity != null && this.mActivity.get() != null) {
            ((Activity)this.mActivity.get()).startActivityForResult(Intent.createChooser((Intent)i, (CharSequence)this.getFileUploadPromptLabel()), this.mRequestCodeFilePicker);
        }
    }

    public static boolean isFileUploadAvailable() {
        return AdvancedWebView.isFileUploadAvailable(false);
    }

    public static boolean isFileUploadAvailable(boolean needsCorrectMimeType) {
        if (Build.VERSION.SDK_INT == 19) {
            String platformVersion = Build.VERSION.RELEASE == null ? "" : Build.VERSION.RELEASE;
            return !needsCorrectMimeType && (platformVersion.startsWith("4.4.3") || platformVersion.startsWith("4.4.4"));
        }
        return true;
    }

    @SuppressLint(value={"NewApi"})
    public static boolean handleDownload(Context context, String fromUrl, String toFilename) {
        if (Build.VERSION.SDK_INT < 9) {
            throw new RuntimeException("Method requires API level 9 or above");
        }
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)fromUrl));
        if (Build.VERSION.SDK_INT >= 11) {
            request.allowScanningByMediaScanner();
            request.setNotificationVisibility(1);
        }
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, toFilename);
        DownloadManager dm = (DownloadManager)context.getSystemService("download");
        try {
            try {
                dm.enqueue(request);
            }
            catch (SecurityException e) {
                if (Build.VERSION.SDK_INT >= 11) {
                    request.setNotificationVisibility(0);
                }
                dm.enqueue(request);
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            AdvancedWebView.openAppSettings(context, PACKAGE_NAME_DOWNLOAD_MANAGER);
            return false;
        }
    }

    @SuppressLint(value={"NewApi"})
    private static boolean openAppSettings(Context context, String packageName) {
        if (Build.VERSION.SDK_INT < 9) {
            throw new RuntimeException("Method requires API level 9 or above");
        }
        try {
            Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.setData(Uri.parse((String)("package:" + packageName)));
            intent.setFlags(0x10000000);
            context.startActivity(intent);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class Browsers {
        private static String mAlternativePackage;

        public static boolean hasAlternative(Context context) {
            return Browsers.getAlternative(context) != null;
        }

        public static String getAlternative(Context context) {
            if (mAlternativePackage != null) {
                return mAlternativePackage;
            }
            List<String> alternativeBrowsers = Arrays.asList(ALTERNATIVE_BROWSERS);
            List apps = context.getPackageManager().getInstalledApplications(128);
            for (ApplicationInfo app : apps) {
                if (!app.enabled || !alternativeBrowsers.contains(app.packageName)) continue;
                mAlternativePackage = app.packageName;
                return app.packageName;
            }
            return null;
        }

        public static void openUrl(Activity context, String url) {
            Browsers.openUrl(context, url, false);
        }

        public static void openUrl(Activity context, String url, boolean withoutTransition) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.setPackage(Browsers.getAlternative((Context)context));
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            if (withoutTransition) {
                context.overridePendingTransition(0, 0);
            }
        }
    }

    public static interface Listener {
        public void onPageStarted(String var1, Bitmap var2);

        public void onPageFinished(String var1);

        public void onPageError(int var1, String var2, String var3);

        public void onDownloadRequested(String var1, String var2, String var3, long var4, String var6, String var7);

        public void onExternalPageRequest(String var1);
    }
}

