/*
 * Decompiled with CFR 0.152.
 */
package com.xandryex;

import com.xandryex.utils.TextReplacer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class WordReplacer {
    private XWPFDocument document;
    private TextReplacer replacer;

    public WordReplacer(File docxFile) throws IOException {
        FileInputStream inputStream = new FileInputStream(docxFile);
        this.init(new XWPFDocument((InputStream)inputStream));
    }

    public WordReplacer(XWPFDocument xwpfDoc) {
        this.init(xwpfDoc);
    }

    private void init(XWPFDocument xwpfDoc) {
        if (xwpfDoc == null) {
            throw new NullPointerException();
        }
        this.document = xwpfDoc;
        this.replacer = new TextReplacer();
    }

    public void replaceWordsInText(String bookmark, String replacement) {
        this.replacer.replaceInText(this.document, bookmark, replacement);
    }

    public void replaceWordsInTables(String bookmark, String replacement) {
        this.replacer.replaceInTable(this.document, bookmark, replacement);
    }

    public File saveAndGetModdedFile(String path) throws Exception {
        File file = new File(path);
        return this.saveToFile(file);
    }

    public File saveAndGetModdedFile(File file) throws Exception {
        return this.saveToFile(file);
    }

    public XWPFDocument getModdedXWPFDoc() {
        return this.document;
    }

    private File saveToFile(File file) throws Exception {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file, false);
            this.document.write((OutputStream)out);
            this.document.close();
            File file2 = file;
            return file2;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }
}

