/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate5.strategy;

import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.redis.hibernate5.regions.RedisEntityRegion;
import org.hibernate.cache.redis.hibernate5.strategy.AbstractReadWriteRedisAccessStrategy;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadWriteRedisEntityRegionAccessStrategy
extends AbstractReadWriteRedisAccessStrategy<RedisEntityRegion>
implements EntityRegionAccessStrategy {
    private static final Logger log = LoggerFactory.getLogger(ReadWriteRedisEntityRegionAccessStrategy.class);

    public ReadWriteRedisEntityRegionAccessStrategy(RedisEntityRegion region, SessionFactoryOptions options) {
        super(region, options);
    }

    public Object generateCacheKey(Object id, EntityPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return DefaultCacheKeysFactory.createEntityKey((Object)id, (EntityPersister)persister, (SessionFactoryImplementor)factory, (String)tenantIdentifier);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return DefaultCacheKeysFactory.getEntityId((Object)cacheKey);
    }

    public EntityRegion getRegion() {
        return (EntityRegion)this.region;
    }

    public boolean insert(SessionImplementor session, Object key, Object value, Object version) {
        ((RedisEntityRegion)this.region).put(key, value);
        return true;
    }

    public boolean afterInsert(SessionImplementor session, Object key, Object value, Object version) {
        ((RedisEntityRegion)this.region).put(key, value);
        return true;
    }

    public boolean update(SessionImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) {
        ((RedisEntityRegion)this.region).put(key, value);
        return true;
    }

    public boolean afterUpdate(SessionImplementor session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        ((RedisEntityRegion)this.region).put(key, value);
        return true;
    }
}

