/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate4.strategy;

import org.hibernate.cache.redis.hibernate4.regions.RedisTransactionalDataRegion;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cfg.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractRedisAccessStrategy<T extends RedisTransactionalDataRegion> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRedisAccessStrategy.class);
    protected final T region;
    protected final Settings settings;

    AbstractRedisAccessStrategy(T region, Settings settings) {
        this.region = region;
        this.settings = settings;
    }

    protected Settings settings() {
        return this.settings;
    }

    public final boolean putFromLoad(Object key, Object value, long txTimestamp, Object version) {
        return this.putFromLoad(key, value, txTimestamp, version, this.settings.isMinimalPutsEnabled());
    }

    public abstract boolean putFromLoad(Object var1, Object var2, long var3, Object var5, boolean var6);

    public final SoftLock lockRegion() {
        return null;
    }

    public final void unlockRegion(SoftLock lock) {
        ((RedisTransactionalDataRegion)this.region).clear();
    }

    public void remove(Object key) {
    }

    public final void removeAll() {
        ((RedisTransactionalDataRegion)this.region).clear();
    }

    public final void evict(Object key) {
        ((RedisTransactionalDataRegion)this.region).remove(key);
    }

    public final void evictAll() {
        ((RedisTransactionalDataRegion)this.region).clear();
    }
}

