/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate4.regions;

import java.util.Properties;
import org.hibernate.cache.redis.client.RedisClient;
import org.hibernate.cache.redis.hibernate4.regions.RedisDataRegion;
import org.hibernate.cache.redis.hibernate4.strategy.RedisAccessStrategyFactory;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RedisGeneralDataRegion
extends RedisDataRegion
implements GeneralDataRegion {
    private static final Logger log = LoggerFactory.getLogger(RedisGeneralDataRegion.class);

    protected RedisGeneralDataRegion(RedisAccessStrategyFactory accessStrategyFactory, RedisClient redis, String regionName, Properties props) {
        super(accessStrategyFactory, redis, regionName, props);
    }

    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        try {
            return this.redis.get(this.getName(), key);
        }
        catch (Exception e) {
            log.warn("Fail to get cache item... key=" + key, (Throwable)e);
            return null;
        }
    }

    public void put(Object key, Object value) {
        try {
            this.redis.set(this.getName(), key, value, this.getExpiryInSeconds());
        }
        catch (Exception e) {
            log.warn("Fail to put cache item... key=" + key, (Throwable)e);
        }
    }

    public void evict(Object key) {
        try {
            this.redis.del(this.getName(), key);
        }
        catch (Exception e) {
            log.warn("Fail to remove cache item... key=" + key, (Throwable)e);
        }
    }

    public void evictAll() {
        try {
            this.redis.deleteRegion(this.getName());
        }
        catch (Exception e) {
            log.warn("Fail to remove cache items... region=" + this.getName(), (Throwable)e);
        }
    }
}

