/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate4.regions;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.redis.client.RedisClient;
import org.hibernate.cache.redis.hibernate4.strategy.RedisAccessStrategyFactory;
import org.hibernate.cache.redis.util.RedisCacheUtil;
import org.hibernate.cache.redis.util.Timestamper;
import org.hibernate.cache.spi.Region;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RedisDataRegion
implements Region {
    private static final Logger log = LoggerFactory.getLogger(RedisDataRegion.class);
    protected final RedisAccessStrategyFactory accessStrategyFactory;
    private final String name;
    protected final RedisClient redis;
    private final int cacheLockTimeout;
    private final int expiryInSeconds;
    protected boolean regionDeleted = false;

    protected RedisDataRegion(RedisAccessStrategyFactory accessStrategyFactory, RedisClient redis, String regionName, Properties props) {
        this.accessStrategyFactory = accessStrategyFactory;
        this.redis = redis;
        this.name = regionName;
        this.cacheLockTimeout = 0;
        this.expiryInSeconds = RedisCacheUtil.getExpiryInSeconds(this.name);
        log.debug("redis region={}, expiryInSeconds={}", (Object)regionName, (Object)this.expiryInSeconds);
    }

    public String getName() {
        return this.name;
    }

    public void destroy() throws CacheException {
    }

    public boolean contains(Object key) {
        try {
            boolean exists = this.redis.exists(this.name, key);
            log.trace("cache contains items? region=[{}], key=[{}], contains=[{}]", new Object[]{this.name, key, exists});
            return exists;
        }
        catch (Throwable ignored) {
            log.warn("Fail to check contains key... region=" + this.name, ignored);
            return false;
        }
    }

    public long getSizeInMemory() {
        try {
            return this.redis.dbSize();
        }
        catch (Throwable ignored) {
            log.warn("Fail to get count of cache items. region=" + this.name, ignored);
            return -1L;
        }
    }

    public long getElementCountInMemory() {
        try {
            return this.redis.keySizeInRegion(this.name);
        }
        catch (Throwable ignored) {
            log.warn("Fail to get count of cache items. region=" + this.name, ignored);
            return -1L;
        }
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public Map toMap() {
        try {
            return this.redis.getAll(this.name);
        }
        catch (Throwable e) {
            log.warn("Fail to build CacheEntry. return EmptyMap.", e);
            return Collections.emptyMap();
        }
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public int getTimeout() {
        return this.cacheLockTimeout;
    }

    public RedisAccessStrategyFactory getAccessStrategyFactory() {
        return this.accessStrategyFactory;
    }

    public RedisClient getRedis() {
        return this.redis;
    }

    public int getCacheLockTimeout() {
        return this.cacheLockTimeout;
    }

    public int getExpiryInSeconds() {
        return this.expiryInSeconds;
    }

    public boolean isRegionDeleted() {
        return this.regionDeleted;
    }
}

