/*
 * Decompiled with CFR 0.152.
 */
package uk.co.deanwild.flowtextview.helpers;

import android.graphics.Typeface;
import android.text.Spannable;
import android.text.TextPaint;
import android.text.style.StyleSpan;
import android.text.style.URLSpan;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import uk.co.deanwild.flowtextview.FlowTextView;
import uk.co.deanwild.flowtextview.helpers.PaintHelper;
import uk.co.deanwild.flowtextview.models.HtmlLink;
import uk.co.deanwild.flowtextview.models.HtmlObject;

public class SpanParser {
    private final PaintHelper mPaintHelper;
    private final FlowTextView mFlowTextView;
    private final List<HtmlLink> mLinks = new ArrayList<HtmlLink>();
    private int mTextLength = 0;
    private Spannable mSpannable;
    private final HashMap<Integer, HtmlObject> sorterMap = new HashMap();

    public SpanParser(FlowTextView flowTextView, PaintHelper paintHelper) {
        this.mFlowTextView = flowTextView;
        this.mPaintHelper = paintHelper;
    }

    public float parseSpans(List<HtmlObject> objects, Object[] spans, int lineStart, int lineEnd, float baseXOffset) {
        String tempString;
        int charCounter;
        int spanEnd;
        int spanStart;
        this.sorterMap.clear();
        int charFlagSize = lineEnd - lineStart;
        boolean[] charFlags = new boolean[charFlagSize];
        for (Object span : spans) {
            spanStart = this.mSpannable.getSpanStart(span);
            spanEnd = this.mSpannable.getSpanEnd(span);
            if (spanStart < lineStart) {
                spanStart = lineStart;
            }
            if (spanEnd > lineEnd) {
                spanEnd = lineEnd;
            }
            for (charCounter = spanStart; charCounter < spanEnd; ++charCounter) {
                int charFlagIndex = charCounter - lineStart;
                charFlags[charFlagIndex] = true;
            }
            tempString = this.extractText(spanStart, spanEnd);
            this.sorterMap.put(spanStart, this.parseSpan(span, tempString, spanStart, spanEnd));
        }
        charCounter = 0;
        while (!SpanParser.isArrayFull(charFlags)) {
            block3: while (charCounter < charFlagSize) {
                if (charFlags[charCounter]) {
                    ++charCounter;
                    continue;
                }
                int temp1 = charCounter;
                while (charCounter <= charFlagSize) {
                    if (charCounter < charFlagSize && !charFlags[charCounter]) {
                        charFlags[charCounter] = true;
                        ++charCounter;
                        continue;
                    }
                    int temp2 = charCounter;
                    spanStart = lineStart + temp1;
                    spanEnd = lineStart + temp2;
                    tempString = this.extractText(spanStart, spanEnd);
                    this.sorterMap.put(spanStart, this.parseSpan(null, tempString, spanStart, spanEnd));
                    continue block3;
                }
            }
        }
        Object[] sorterKeys = this.sorterMap.keySet().toArray();
        Arrays.sort(sorterKeys);
        float thisXoffset = baseXOffset;
        for (charCounter = 0; charCounter < sorterKeys.length; ++charCounter) {
            HtmlObject thisObj = this.sorterMap.get(sorterKeys[charCounter]);
            thisObj.xOffset = thisXoffset;
            thisXoffset += thisObj.paint.measureText(thisObj.content);
            objects.add(thisObj);
        }
        return thisXoffset - baseXOffset;
    }

    private HtmlObject parseSpan(Object span, String content, int start, int end) {
        if (span instanceof URLSpan) {
            return this.getHtmlLink((URLSpan)span, content, start, end, 0.0f);
        }
        if (span instanceof StyleSpan) {
            return this.getStyledObject((StyleSpan)span, content, start, end, 0.0f);
        }
        return this.getHtmlObject(content, start, end, 0.0f);
    }

    private HtmlObject getStyledObject(StyleSpan span, String content, int start, int end, float thisXOffset) {
        TextPaint paint = this.mPaintHelper.getPaintFromHeap();
        paint.setTypeface(Typeface.defaultFromStyle((int)span.getStyle()));
        paint.setTextSize(this.mFlowTextView.getTextsize());
        paint.setColor(this.mFlowTextView.getColor());
        span.updateDrawState(paint);
        span.updateMeasureState(paint);
        HtmlObject obj = new HtmlObject(content, start, end, thisXOffset, paint);
        obj.recycle = true;
        return obj;
    }

    private HtmlObject getHtmlObject(String content, int start, int end, float thisXOffset) {
        return new HtmlObject(content, start, end, thisXOffset, this.mFlowTextView.getTextPaint());
    }

    public void reset() {
        this.mLinks.clear();
    }

    private HtmlLink getHtmlLink(URLSpan span, String content, int start, int end, float thisXOffset) {
        HtmlLink obj = new HtmlLink(content, start, end, thisXOffset, this.mFlowTextView.getLinkPaint(), span.getURL());
        this.mLinks.add(obj);
        return obj;
    }

    public void addLink(HtmlLink thisLink, float yOffset, float width, float height) {
        thisLink.yOffset = yOffset - 20.0f;
        thisLink.width = width;
        thisLink.height = height + 20.0f;
        this.mLinks.add(thisLink);
    }

    private String extractText(int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (end > this.mTextLength - 1) {
            end = this.mTextLength - 1;
        }
        return this.mSpannable.subSequence(start, end).toString();
    }

    private static boolean isArrayFull(boolean[] array) {
        for (int arrayIndex = 0; arrayIndex < array.length; ++arrayIndex) {
            if (array[arrayIndex]) continue;
            return false;
        }
        return true;
    }

    public List<HtmlLink> getLinks() {
        return this.mLinks;
    }

    public Spannable getSpannable() {
        return this.mSpannable;
    }

    public void setSpannable(Spannable mSpannable) {
        this.mSpannable = mSpannable;
        this.mTextLength = mSpannable.length();
    }
}

