/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddth.dlock.impl.redis;

import com.github.ddth.commons.redis.JedisConnector;
import com.github.ddth.commons.redis.JedisUtils;
import com.github.ddth.dlock.impl.redis.BaseRedisDLockFactory;
import com.github.ddth.dlock.impl.redis.ClusteredRedisDLock;
import java.util.Properties;

public class ClusteredRedisDLockFactory
extends BaseRedisDLockFactory {
    private String redisHostsAndPorts = "localhost:6379";

    public String getRedisHostsAndPorts() {
        return this.redisHostsAndPorts;
    }

    public ClusteredRedisDLockFactory setRedisHostsAndPorts(String redisHostsAndPorts) {
        this.redisHostsAndPorts = redisHostsAndPorts;
        return this;
    }

    @Override
    protected JedisConnector buildJedisConnector() {
        JedisConnector jedisConnector = new JedisConnector();
        jedisConnector.setJedisPoolConfig(JedisUtils.defaultJedisPoolConfig()).setRedisHostsAndPorts(this.getRedisHostsAndPorts()).setRedisPassword(this.getRedisPassword()).init();
        return jedisConnector;
    }

    @Override
    public ClusteredRedisDLock createLock(String name) {
        return (ClusteredRedisDLock)super.createLock(name);
    }

    @Override
    protected ClusteredRedisDLock createLockInternal(String name, Properties lockProps) {
        ClusteredRedisDLock lock = new ClusteredRedisDLock(name);
        lock.setLockProperties(lockProps);
        lock.setRedisHostsAndPorts(this.getRedisHostsAndPorts()).setRedisPassword(this.getRedisPassword());
        lock.setJedisConnector(this.getJedisConnector());
        return lock;
    }
}

