/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddth.dlock.impl.redis;

import com.github.ddth.commons.redis.JedisConnector;
import com.github.ddth.dlock.LockResult;
import com.github.ddth.dlock.impl.AbstractDLock;
import com.github.ddth.dlock.impl.redis.internal.RedisUtils;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.commands.JedisClusterCommands;
import redis.clients.jedis.commands.JedisCommands;

public abstract class BaseRedisDLock
extends AbstractDLock {
    private final Logger LOGGER = LoggerFactory.getLogger(BaseRedisDLock.class);
    public static final String LOCK_PROP_REDIS_PASSWORD = "dlock.redis_password";
    private String scriptLock;
    private String scriptUnlock;
    private JedisConnector jedisConnector;
    protected boolean myOwnRedis = true;
    private String redisPassword;

    public BaseRedisDLock(String name) {
        super(name);
    }

    public JedisConnector getJedisConnector() {
        return this.jedisConnector;
    }

    public BaseRedisDLock setJedisConnector(JedisConnector jedisConnector) {
        if (this.myOwnRedis && this.jedisConnector != null) {
            this.jedisConnector.destroy();
        }
        this.jedisConnector = jedisConnector;
        this.myOwnRedis = false;
        return this;
    }

    public String getRedisPassword() {
        return this.redisPassword;
    }

    public BaseRedisDLock setRedisPassword(String redisPassword) {
        this.redisPassword = redisPassword;
        return this;
    }

    protected abstract JedisConnector buildJedisConnector();

    @Override
    public BaseRedisDLock init() {
        super.init();
        String password = this.getLockProperty(LOCK_PROP_REDIS_PASSWORD);
        if (!StringUtils.isBlank((CharSequence)password)) {
            this.redisPassword = password;
        }
        if (this.jedisConnector == null) {
            this.jedisConnector = this.buildJedisConnector();
            this.myOwnRedis = this.jedisConnector != null;
        }
        this.scriptLock = "local cval=redis.call(\"get\", ARGV[1]); if cval and cval~=ARGV[2] then return nil else return redis.call(\"set\", ARGV[1], ARGV[2], \"PX\", ARGV[3]); end";
        this.scriptUnlock = "local cval=redis.call(\"get\", ARGV[1]); if cval and cval~=ARGV[2] then return nil else return redis.call(\"del\", ARGV[1]); end";
        return this;
    }

    @Override
    public void destroy() {
        try {
            super.destroy();
        }
        finally {
            try {
                this.jedisConnector = RedisUtils.closeJedisConnector(this.jedisConnector, this.myOwnRedis);
            }
            catch (Exception e) {
                this.LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected String getScriptLock() {
        return this.scriptLock;
    }

    protected BaseRedisDLock setScriptLock(String scriptLock) {
        this.scriptLock = scriptLock;
        return this;
    }

    protected String getScriptUnlock() {
        return this.scriptUnlock;
    }

    protected BaseRedisDLock setScriptUnlock(String scriptUnlock) {
        this.scriptUnlock = scriptUnlock;
        return this;
    }

    private void doUpdateLockHolder(Function<String, String> funcGetClientIdFromRedis, Function<String, Long> funcGetTtlFromRedis) {
        String key = this.getName();
        String clientId = funcGetClientIdFromRedis.apply(key);
        this.setClientId(clientId);
        if (!StringUtils.isBlank((CharSequence)clientId)) {
            Long ttl = funcGetTtlFromRedis.apply(key);
            if (ttl != null && ttl != -2L) {
                this.setTimestampExpiry(ttl != -1L ? System.currentTimeMillis() + ttl : Integer.MAX_VALUE);
            } else {
                this.setTimestampExpiry(Integer.MAX_VALUE);
            }
        } else {
            this.setTimestampExpiry(0L);
        }
    }

    protected void updateLockHolder(JedisClusterCommands jedisClusterCommands) {
        this.doUpdateLockHolder(arg_0 -> ((JedisClusterCommands)jedisClusterCommands).get(arg_0), arg_0 -> ((JedisClusterCommands)jedisClusterCommands).pttl(arg_0));
    }

    protected void updateLockHolder(JedisCommands jedisCommands) {
        this.doUpdateLockHolder(arg_0 -> ((JedisCommands)jedisCommands).get(arg_0), arg_0 -> ((JedisCommands)jedisCommands).pttl(arg_0));
    }

    protected String getZsetName() {
        return this.getName() + "-z";
    }

    protected LockResult unlockResult(Object response) {
        if (response == null) {
            return LockResult.HOLD_BY_ANOTHER_CLIENT;
        }
        if ("0".equals(response.toString())) {
            return LockResult.NOT_FOUND;
        }
        return LockResult.SUCCESSFUL;
    }
}

