/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddth.dlock.impl;

import com.github.ddth.dlock.IDLockFactory;
import com.github.ddth.dlock.impl.AbstractDLock;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDLockFactory
implements IDLockFactory,
AutoCloseable {
    private Logger LOGGER = LoggerFactory.getLogger(AbstractDLockFactory.class);
    private String lockNamePrefix;
    private Map<String, Properties> lockProperties;
    private Cache<String, AbstractDLock> lockInstances = CacheBuilder.newBuilder().expireAfterAccess(3600L, TimeUnit.SECONDS).removalListener(notification -> {
        AbstractDLock lock = (AbstractDLock)notification.getValue();
        try {
            lock.destroy();
        }
        catch (Exception e) {
            this.LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }).build();

    public AbstractDLockFactory init() {
        return this;
    }

    public void destroy() {
        this.lockInstances.invalidateAll();
    }

    @Override
    public void close() {
        this.destroy();
    }

    protected String buildLockName(String lockName) {
        return this.lockNamePrefix != null ? this.lockNamePrefix + lockName : lockName;
    }

    public String getLockNamePrefix() {
        return this.lockNamePrefix;
    }

    public AbstractDLockFactory setLockNamePrefix(String lockNamePrefix) {
        this.lockNamePrefix = lockNamePrefix;
        return this;
    }

    public AbstractDLockFactory setLockProperties(Map<String, Properties> lockProperties) {
        this.lockProperties = lockProperties;
        return this;
    }

    protected Map<String, Properties> getLockPropertiesMap() {
        return this.lockProperties;
    }

    protected Properties getLockProperties(String name) {
        return this.lockProperties != null ? this.lockProperties.get(name) : null;
    }

    @Override
    public AbstractDLock createLock(String name) {
        String lockName = this.buildLockName(name);
        try {
            AbstractDLock lock = (AbstractDLock)this.lockInstances.get((Object)lockName, () -> {
                Properties lockProps = this.getLockProperties(name);
                return this.createAndInitLockInstance(lockName, lockProps);
            });
            return lock;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    protected AbstractDLock createAndInitLockInstance(String name, Properties lockProps) {
        AbstractDLock lock = this.createLockInternal(name, lockProps);
        lock.init();
        return lock;
    }

    protected abstract AbstractDLock createLockInternal(String var1, Properties var2);
}

