/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddth.dlock.impl.redis;

import com.github.ddth.commons.redis.JedisConnector;
import com.github.ddth.commons.redis.JedisUtils;
import com.github.ddth.dlock.LockResult;
import com.github.ddth.dlock.impl.redis.BaseRedisDLock;
import org.apache.commons.lang3.StringUtils;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisCommands;

public class ClusteredRedisDLock
extends BaseRedisDLock {
    public static final String LOCK_PROP_REDIS_HOSTS_AND_PORTS = "dlock.redis_hosts_and_ports";
    private String redisHostsAndPorts = "localhost:6379";

    public ClusteredRedisDLock(String name) {
        super(name);
    }

    public String getRedisHostsAndPorts() {
        return this.redisHostsAndPorts;
    }

    public ClusteredRedisDLock setRedisHostsAndPorts(String redisHostsAndPorts) {
        this.redisHostsAndPorts = redisHostsAndPorts;
        return this;
    }

    @Override
    protected JedisConnector buildJedisConnector() {
        JedisConnector jedisConnector = new JedisConnector();
        jedisConnector.setJedisPoolConfig(JedisUtils.defaultJedisPoolConfig()).setRedisHostsAndPorts(this.redisHostsAndPorts).init();
        return jedisConnector;
    }

    @Override
    public ClusteredRedisDLock init() {
        String hostsAndPorts = this.getLockProperty(LOCK_PROP_REDIS_HOSTS_AND_PORTS);
        if (!StringUtils.isBlank((CharSequence)hostsAndPorts)) {
            this.redisHostsAndPorts = hostsAndPorts;
        }
        super.init();
        return this;
    }

    protected JedisCluster getJedis() {
        return this.getJedisConnector().getJedisCluster();
    }

    @Override
    public LockResult lock(int waitWeight, String clientId, long lockDurationMs) {
        if (StringUtils.isBlank((CharSequence)clientId)) {
            throw new IllegalArgumentException("Invalid ClientID!");
        }
        if (lockDurationMs <= 0L) {
            throw new IllegalArgumentException("Lock duration must be greater than zero!");
        }
        JedisCluster jedis = this.getJedis();
        String zsetName = this.getZsetName();
        if (waitWeight >= 0) {
            jedis.zadd(zsetName, (double)waitWeight, clientId);
            Long rank = jedis.zrevrank(zsetName, clientId);
            if (rank != null && rank.intValue() != 0) {
                return LockResult.HOLD_BY_ANOTHER_CLIENT;
            }
        }
        String key = this.getName();
        Object response = jedis.eval(this.getScriptLock(), 0, new String[]{key, clientId, String.valueOf(lockDurationMs)});
        if (response == null) {
            this.updateLockHolder((JedisCommands)jedis);
            return LockResult.HOLD_BY_ANOTHER_CLIENT;
        }
        this.updateLockHolder(clientId, lockDurationMs);
        if (waitWeight >= 0) {
            jedis.del(zsetName);
        }
        return LockResult.SUCCESSFUL;
    }

    @Override
    public LockResult unlock(String clientId) {
        if (StringUtils.isBlank((CharSequence)clientId)) {
            throw new IllegalArgumentException("Invalid ClientID!");
        }
        JedisCluster jedis = this.getJedis();
        String key = this.getName();
        Object response = jedis.eval(this.getScriptUnlock(), 0, new String[]{key, clientId});
        if (response == null) {
            return LockResult.HOLD_BY_ANOTHER_CLIENT;
        }
        if ("0".equals(response.toString())) {
            return LockResult.NOT_FOUND;
        }
        return LockResult.SUCCESSFUL;
    }
}

