/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddth.dlock.impl.redis;

import com.github.ddth.commons.redis.JedisConnector;
import com.github.ddth.dlock.impl.AbstractDLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisCommands;

public abstract class BaseRedisDLock
extends AbstractDLock {
    private final Logger LOGGER = LoggerFactory.getLogger(BaseRedisDLock.class);
    public static final String LOCK_PROP_REDIS_PASSWORD = "dlock.redis_password";
    private String scriptLock;
    private String scriptUnlock;
    private JedisConnector jedisConnector;
    protected boolean myOwnRedis = true;
    private String redisPassword;

    public BaseRedisDLock(String name) {
        super(name);
    }

    public JedisConnector getJedisConnector() {
        return this.jedisConnector;
    }

    public BaseRedisDLock setJedisConnector(JedisConnector jedisConnector) {
        if (this.myOwnRedis && this.jedisConnector != null) {
            this.jedisConnector.destroy();
        }
        this.jedisConnector = jedisConnector;
        this.myOwnRedis = false;
        return this;
    }

    public String getRedisPassword() {
        return this.redisPassword;
    }

    public BaseRedisDLock setRedisPassword(String redisPassword) {
        this.redisPassword = redisPassword;
        return this;
    }

    protected abstract JedisConnector buildJedisConnector();

    @Override
    public BaseRedisDLock init() {
        super.init();
        String password = this.getLockProperty(LOCK_PROP_REDIS_PASSWORD);
        if (!StringUtils.isBlank((CharSequence)password)) {
            this.redisPassword = password;
        }
        if (this.jedisConnector == null) {
            this.jedisConnector = this.buildJedisConnector();
            this.myOwnRedis = this.jedisConnector != null;
        }
        this.scriptLock = "local cval=redis.call(\"get\", ARGV[1]); if cval and cval~=ARGV[2] then return nil else return redis.call(\"set\", ARGV[1], ARGV[2], \"PX\", ARGV[3]); end";
        this.scriptUnlock = "local cval=redis.call(\"get\", ARGV[1]); if cval and cval~=ARGV[2] then return nil else return redis.call(\"del\", ARGV[1]); end";
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        try {
            super.destroy();
        }
        finally {
            if (this.jedisConnector != null && this.myOwnRedis) {
                try {
                    this.jedisConnector.destroy();
                }
                catch (Exception e) {
                    this.LOGGER.warn(e.getMessage(), (Throwable)e);
                }
                finally {
                    this.jedisConnector = null;
                }
            }
        }
    }

    protected String getScriptLock() {
        return this.scriptLock;
    }

    protected BaseRedisDLock setScriptLock(String scriptLock) {
        this.scriptLock = scriptLock;
        return this;
    }

    protected String getScriptUnlock() {
        return this.scriptUnlock;
    }

    protected BaseRedisDLock setScriptUnlock(String scriptUnlock) {
        this.scriptUnlock = scriptUnlock;
        return this;
    }

    protected void updateLockHolder(JedisCommands jedisCommands) {
        String key = this.getName();
        String clientId = jedisCommands.get(key);
        this.setClientId(clientId);
        if (!StringUtils.isBlank((CharSequence)clientId)) {
            Long ttl = jedisCommands.pttl(key);
            if (ttl != null && ttl != -2L) {
                this.setTimestampExpiry(ttl != -1L ? System.currentTimeMillis() + ttl : Integer.MAX_VALUE);
            } else {
                this.setTimestampExpiry(Integer.MAX_VALUE);
            }
        } else {
            this.setTimestampExpiry(0L);
        }
    }

    protected String getZsetName() {
        return this.getName() + "-z";
    }
}

