/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddth.dlock.impl.inmem;

import com.github.ddth.dlock.DLockException;
import com.github.ddth.dlock.LockResult;
import com.github.ddth.dlock.impl.AbstractDLock;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.commons.lang3.StringUtils;

public class InmemDLock
extends AbstractDLock {
    private Queue<Token> pQueue = new PriorityQueue<Token>(new Comparator<Token>(){

        @Override
        public int compare(Token t1, Token t2) {
            return t2.waitWeight - t1.waitWeight;
        }
    });

    public InmemDLock(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockResult lock(int waitWeight, String clientId, long lockDurationMs) {
        Object object;
        if (StringUtils.isBlank((CharSequence)clientId)) {
            throw new IllegalArgumentException("Invalid ClientID!");
        }
        if (lockDurationMs <= 0L) {
            throw new IllegalArgumentException("Lock duration must be greater than zero!");
        }
        if (waitWeight >= 0) {
            object = this.pQueue;
            synchronized (object) {
                this.pQueue.add(new Token(clientId, waitWeight));
            }
        }
        object = this;
        synchronized (object) {
            try {
                Object token;
                if (waitWeight >= 0 && (token = this.pQueue.peek()) != null && !StringUtils.equals((CharSequence)((Token)token).clientId, (CharSequence)clientId)) {
                    return LockResult.HOLD_BY_ANOTHER_CLIENT;
                }
                if (!StringUtils.isBlank((CharSequence)this.getClientId()) && this.getTimestampExpiry() >= System.currentTimeMillis() && !StringUtils.equals((CharSequence)this.getClientId(), (CharSequence)clientId)) {
                    return LockResult.HOLD_BY_ANOTHER_CLIENT;
                }
                this.updateLockHolder(clientId, lockDurationMs);
                if (waitWeight >= 0) {
                    token = this.pQueue;
                    synchronized (token) {
                        this.pQueue.clear();
                    }
                }
                return LockResult.SUCCESSFUL;
            }
            catch (Exception e) {
                throw e instanceof DLockException ? (DLockException)e : new DLockException(e);
            }
        }
    }

    @Override
    public LockResult unlock(String clientId) {
        if (StringUtils.isBlank((CharSequence)clientId)) {
            throw new IllegalArgumentException("Invalid ClientID!");
        }
        InmemDLock inmemDLock = this;
        synchronized (inmemDLock) {
            try {
                if (StringUtils.isBlank((CharSequence)this.getClientId())) {
                    return LockResult.NOT_FOUND;
                }
                if (this.getTimestampExpiry() >= System.currentTimeMillis() && !StringUtils.equals((CharSequence)this.getClientId(), (CharSequence)clientId)) {
                    return LockResult.HOLD_BY_ANOTHER_CLIENT;
                }
                this.updateLockHolder(null, 0L);
                return LockResult.SUCCESSFUL;
            }
            catch (Exception e) {
                throw e instanceof DLockException ? (DLockException)e : new DLockException(e);
            }
        }
    }

    private static class Token {
        public final String clientId;
        public final int waitWeight;

        public Token(String clientId, int waitWeight) {
            this.clientId = clientId;
            this.waitWeight = waitWeight;
        }
    }
}

