/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddth.dlock.impl.redis;

import com.github.ddth.dlock.LockResult;
import com.github.ddth.dlock.impl.redis.BaseRedisDLock;
import com.github.ddth.dlock.impl.redis.JedisConnector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCommands;

public class RedisDLock
extends BaseRedisDLock {
    private final Logger LOGGER = LoggerFactory.getLogger(RedisDLock.class);
    public static final String LOCK_PROP_REDIS_HOST_AND_PORT = "dlock.redis_host_and_port";
    private String redisHostAndPort = "localhost:6379";

    public RedisDLock(String name) {
        super(name);
    }

    protected Jedis getJedis() {
        return this.getJedisConnector().getJedis();
    }

    public String getRedisHostAndPort() {
        return this.redisHostAndPort;
    }

    public RedisDLock setRedisHostAndPort(String redisHostAndPort) {
        this.redisHostAndPort = redisHostAndPort;
        return this;
    }

    @Override
    public RedisDLock init() {
        super.init();
        String hostAndPort = this.getLockProperty(LOCK_PROP_REDIS_HOST_AND_PORT);
        if (!StringUtils.isBlank((CharSequence)hostAndPort)) {
            this.redisHostAndPort = hostAndPort;
        }
        if (this.getJedisConnector() == null) {
            try {
                JedisConnector jedisConnector = new JedisConnector();
                jedisConnector.setRedisHostsAndPorts(this.redisHostAndPort).init();
                this.setJedisConnector(jedisConnector);
            }
            catch (Exception e) {
                this.LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        return this;
    }

    @Override
    public LockResult lock(String clientId, long lockDurationMs) {
        if (StringUtils.isBlank((CharSequence)clientId)) {
            throw new IllegalArgumentException("Invalid ClientID!");
        }
        if (lockDurationMs <= 0L) {
            throw new IllegalArgumentException("Lock duration must be greater than zero!");
        }
        try (Jedis jedis = this.getJedis();){
            String key = this.getName();
            Object response = jedis.eval(this.getScriptLock(), 0, new String[]{key, clientId, String.valueOf(lockDurationMs)});
            if (response == null) {
                this.updateLockHolder((JedisCommands)jedis);
                LockResult lockResult = LockResult.HOLD_BY_ANOTHER_CLIENT;
                return lockResult;
            }
            this.updateLockHolder(clientId, lockDurationMs);
            LockResult lockResult = LockResult.SUCCESSFUL;
            return lockResult;
        }
    }

    @Override
    public LockResult unlock(String clientId) {
        if (StringUtils.isBlank((CharSequence)clientId)) {
            throw new IllegalArgumentException("Invalid ClientID!");
        }
        try (Jedis jedis = this.getJedis();){
            String key = this.getName();
            Object response = jedis.eval(this.getScriptUnlock(), 0, new String[]{key, clientId});
            if (response == null) {
                LockResult lockResult = LockResult.HOLD_BY_ANOTHER_CLIENT;
                return lockResult;
            }
            if ("0".equals(response.toString())) {
                LockResult lockResult = LockResult.NOT_FOUND;
                return lockResult;
            }
            LockResult lockResult = LockResult.SUCCESSFUL;
            return lockResult;
        }
    }
}

