/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddth.dlock.impl.redis;

import com.github.ddth.dlock.DLockException;
import com.github.ddth.dlock.impl.redis.ClusteredRedisDLockFactory;
import com.github.ddth.dlock.impl.redis.RedisDLockFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;

public class JedisConnector
implements AutoCloseable {
    private final Logger LOGGER = LoggerFactory.getLogger(JedisConnector.class);
    private String redisHostsAndPorts = "localhost:6379";
    private String redisPassword;
    private JedisPool jedisPool;
    private JedisCluster jedisCluster;

    public String getRedisHostsAndPorts() {
        return this.redisHostsAndPorts;
    }

    public JedisConnector setRedisHostsAndPorts(String redisHostsAndPorts) {
        this.redisHostsAndPorts = redisHostsAndPorts;
        return this;
    }

    public String getRedisPassword() {
        return this.redisPassword;
    }

    public JedisConnector setRedisPassword(String redisPassword) {
        this.redisPassword = redisPassword;
        return this;
    }

    private synchronized void connectJedisPool() throws DLockException {
        if (this.jedisPool == null) {
            String[] tokens = this.redisHostsAndPorts.split("[,;\\s]+");
            this.jedisPool = RedisDLockFactory.newJedisPool(tokens[0], this.getRedisPassword());
        }
    }

    public Jedis getJedis() {
        if (this.jedisPool == null) {
            this.connectJedisPool();
        }
        return this.jedisPool.getResource();
    }

    private synchronized void connectJedisCluster() throws DLockException {
        if (this.jedisCluster == null) {
            this.jedisCluster = ClusteredRedisDLockFactory.newJedisCluster(this.redisHostsAndPorts, this.getRedisPassword());
        }
    }

    public JedisCluster getJedisCluster() {
        if (this.jedisCluster == null) {
            this.connectJedisCluster();
        }
        return this.jedisCluster;
    }

    public JedisConnector init() {
        return this;
    }

    public void destroy() {
        if (this.jedisPool != null) {
            try {
                this.jedisPool.close();
            }
            catch (Exception e) {
                this.LOGGER.warn(e.getMessage(), (Throwable)e);
            }
            finally {
                this.jedisPool = null;
            }
        }
        if (this.jedisCluster != null) {
            try {
                this.jedisCluster.close();
            }
            catch (Exception e) {
                this.LOGGER.warn(e.getMessage(), (Throwable)e);
            }
            finally {
                this.jedisCluster = null;
            }
        }
    }

    @Override
    public void close() {
        this.destroy();
    }
}

