/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddth.dlock.impl.redis;

import com.github.ddth.commons.redis.JedisConnector;
import com.github.ddth.commons.redis.JedisUtils;
import com.github.ddth.dlock.impl.redis.BaseRedisDLockFactory;
import com.github.ddth.dlock.impl.redis.RedisDLock;
import java.util.Properties;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisDLockFactory
extends BaseRedisDLockFactory {
    private String redisHostAndPort = "localhost:6379";

    public static JedisPool newJedisPool(String hostAndPort, String password) {
        return RedisDLockFactory.newJedisPool(hostAndPort, password, 0, 2000L);
    }

    public static JedisPool newJedisPool(String hostAndPort, String password, int db) {
        return RedisDLockFactory.newJedisPool(hostAndPort, password, db, 2000L);
    }

    public static JedisPool newJedisPool(String hostAndPort, String password, long timeoutMs) {
        return RedisDLockFactory.newJedisPool(hostAndPort, password, 0, timeoutMs);
    }

    public static JedisPool newJedisPool(String hostAndPort, String password, int db, long timeoutMs) {
        int maxTotal = Runtime.getRuntime().availableProcessors();
        int maxIdle = maxTotal / 2;
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(maxTotal);
        poolConfig.setMinIdle(1);
        poolConfig.setMaxIdle(maxIdle > 0 ? maxIdle : 1);
        poolConfig.setMaxWaitMillis(timeoutMs + 1000L);
        poolConfig.setTestWhileIdle(true);
        String[] tokens = hostAndPort.split(":");
        String host = tokens.length > 0 ? tokens[0] : "localhost";
        int port = tokens.length > 1 ? Integer.parseInt(tokens[1]) : 6379;
        JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, (int)timeoutMs, password, db);
        return jedisPool;
    }

    public String getRedisHostAndPort() {
        return this.redisHostAndPort;
    }

    public RedisDLockFactory setRedisHostAndPort(String redisHostAndPort) {
        this.redisHostAndPort = redisHostAndPort;
        return this;
    }

    @Override
    protected JedisConnector buildJedisConnector() {
        JedisConnector jedisConnector = new JedisConnector();
        jedisConnector.setJedisPoolConfig(JedisUtils.defaultJedisPoolConfig()).setRedisHostsAndPorts(this.getRedisHostAndPort()).setRedisPassword(this.getRedisPassword()).init();
        return jedisConnector;
    }

    @Override
    protected RedisDLock createLockInternal(String name, Properties lockProps) {
        RedisDLock lock = new RedisDLock(name);
        lock.setLockProperties(lockProps);
        lock.setRedisHostAndPort(this.getRedisHostAndPort()).setRedisPassword(this.getRedisPassword());
        lock.setJedisConnector(this.getJedisConnector());
        return lock;
    }
}

