/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddth.dlock.impl.redis;

import com.github.ddth.commons.redis.JedisConnector;
import com.github.ddth.commons.redis.JedisUtils;
import com.github.ddth.dlock.impl.redis.BaseRedisDLockFactory;
import com.github.ddth.dlock.impl.redis.ClusteredRedisDLock;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;

public class ClusteredRedisDLockFactory
extends BaseRedisDLockFactory {
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    private String redisHostsAndPorts = "localhost:6379";

    public static JedisCluster newJedisCluster(String hostsAndPorts, String password) {
        return ClusteredRedisDLockFactory.newJedisCluster(hostsAndPorts, password, 2000L);
    }

    public static JedisCluster newJedisCluster(String hostsAndPorts, String password, long timeoutMs) {
        String[] hapList;
        int maxTotal = Runtime.getRuntime().availableProcessors();
        int maxIdle = maxTotal / 2;
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(maxTotal);
        poolConfig.setMinIdle(1);
        poolConfig.setMaxIdle(maxIdle > 0 ? maxIdle : 1);
        poolConfig.setMaxWaitMillis(timeoutMs + 1000L);
        poolConfig.setTestWhileIdle(true);
        HashSet<HostAndPort> clusterNodes = new HashSet<HostAndPort>();
        for (String hostAndPort : hapList = hostsAndPorts.split("[,;\\s]+")) {
            String[] tokens = hostAndPort.split(":");
            String host = tokens.length > 0 ? tokens[0] : "localhost";
            int port = tokens.length > 1 ? Integer.parseInt(tokens[1]) : 6379;
            clusterNodes.add(new HostAndPort(host, port));
        }
        JedisCluster jedisCluster = new JedisCluster(clusterNodes, (int)timeoutMs, (int)timeoutMs, 3, password, (GenericObjectPoolConfig)poolConfig);
        return jedisCluster;
    }

    public String getRedisHostsAndPorts() {
        return this.redisHostsAndPorts;
    }

    public ClusteredRedisDLockFactory setRedisHostsAndPorts(String redisHostsAndPorts) {
        this.redisHostsAndPorts = redisHostsAndPorts;
        return this;
    }

    @Override
    protected JedisConnector buildJedisConnector() {
        JedisConnector jedisConnector = new JedisConnector();
        jedisConnector.setJedisPoolConfig(JedisUtils.defaultJedisPoolConfig()).setRedisHostsAndPorts(this.getRedisHostsAndPorts()).setRedisPassword(this.getRedisPassword()).init();
        return jedisConnector;
    }

    @Override
    protected ClusteredRedisDLock createLockInternal(String name, Properties lockProps) {
        ClusteredRedisDLock lock = new ClusteredRedisDLock(name);
        lock.setLockProperties(lockProps);
        lock.setRedisHostsAndPorts(this.getRedisHostsAndPorts()).setRedisPassword(this.getRedisPassword());
        lock.setJedisConnector(this.getJedisConnector());
        return lock;
    }
}

