/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddth.dlock.impl.redis;

import com.github.ddth.commons.redis.JedisConnector;
import com.github.ddth.dlock.impl.AbstractDLockFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRedisDLockFactory
extends AbstractDLockFactory {
    private final Logger LOGGER = LoggerFactory.getLogger(BaseRedisDLockFactory.class);
    protected boolean myOwnRedis = false;
    private String redisPassword;
    private JedisConnector jedisConnector;

    public String getRedisPassword() {
        return this.redisPassword;
    }

    public BaseRedisDLockFactory setRedisPassword(String redisPassword) {
        this.redisPassword = redisPassword;
        return this;
    }

    protected JedisConnector getJedisConnector() {
        return this.jedisConnector;
    }

    public BaseRedisDLockFactory setJedisConnector(JedisConnector jedisConnector) {
        if (this.myOwnRedis && this.jedisConnector != null) {
            this.jedisConnector.close();
        }
        this.jedisConnector = jedisConnector;
        this.myOwnRedis = false;
        return this;
    }

    protected abstract JedisConnector buildJedisConnector();

    @Override
    public BaseRedisDLockFactory init() {
        if (this.jedisConnector == null) {
            this.jedisConnector = this.buildJedisConnector();
            this.myOwnRedis = this.jedisConnector != null;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        try {
            super.destroy();
        }
        finally {
            if (this.jedisConnector != null && this.myOwnRedis) {
                try {
                    this.jedisConnector.destroy();
                }
                catch (Exception e) {
                    this.LOGGER.warn(e.getMessage(), (Throwable)e);
                }
                finally {
                    this.jedisConnector = null;
                }
            }
        }
    }
}

