/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddth.dlock.impl.inmem;

import com.github.ddth.dlock.DLockException;
import com.github.ddth.dlock.LockResult;
import com.github.ddth.dlock.impl.AbstractDLock;
import org.apache.commons.lang3.StringUtils;

public class InmemDLock
extends AbstractDLock {
    public InmemDLock(String name) {
        super(name);
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public LockResult lock(String clientId, long lockDurationMs) {
        if (StringUtils.isBlank((CharSequence)clientId)) {
            throw new IllegalArgumentException("Invalid ClientID!");
        }
        if (lockDurationMs <= 0L) {
            throw new IllegalArgumentException("Lock duration must be greater than zero!");
        }
        InmemDLock inmemDLock = this;
        synchronized (inmemDLock) {
            try {
                if (!StringUtils.isBlank((CharSequence)this.getClientId()) && this.getTimestampExpiry() >= System.currentTimeMillis() && !StringUtils.equals((CharSequence)this.getClientId(), (CharSequence)clientId)) {
                    return LockResult.HOLD_BY_ANOTHER_CLIENT;
                }
                this.updateLockHolder(clientId, lockDurationMs);
                return LockResult.SUCCESSFUL;
            }
            catch (Exception e) {
                throw e instanceof DLockException ? (DLockException)e : new DLockException(e);
            }
        }
    }

    @Override
    public LockResult unlock(String clientId) {
        if (StringUtils.isBlank((CharSequence)clientId)) {
            throw new IllegalArgumentException("Invalid ClientID!");
        }
        InmemDLock inmemDLock = this;
        synchronized (inmemDLock) {
            try {
                if (StringUtils.isBlank((CharSequence)this.getClientId())) {
                    return LockResult.NOT_FOUND;
                }
                if (this.getTimestampExpiry() >= System.currentTimeMillis() && !StringUtils.equals((CharSequence)this.getClientId(), (CharSequence)clientId)) {
                    return LockResult.HOLD_BY_ANOTHER_CLIENT;
                }
                this.updateLockHolder(null, 0L);
                return LockResult.SUCCESSFUL;
            }
            catch (Exception e) {
                throw e instanceof DLockException ? (DLockException)e : new DLockException(e);
            }
        }
    }
}

