/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddth.dlock.impl;

import com.github.ddth.dlock.IDLock;
import com.github.ddth.dlock.LockResult;
import java.util.Properties;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public abstract class AbstractDLock
implements IDLock,
AutoCloseable {
    private String name;
    private Properties lockProps;
    private String clientId;
    private long timestampExpiry;

    public AbstractDLock(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public AbstractDLock setName(String name) {
        this.name = name;
        return this;
    }

    protected void updateLockHolder(String clientId, long lockDurationMs) {
        this.clientId = clientId;
        this.timestampExpiry = System.currentTimeMillis() + lockDurationMs;
    }

    protected String getClientId() {
        return this.clientId;
    }

    protected AbstractDLock setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    protected long getTimestampExpiry() {
        return this.timestampExpiry;
    }

    protected AbstractDLock setTimestampExpiry(long timestampExpiry) {
        this.timestampExpiry = timestampExpiry;
        return this;
    }

    public AbstractDLock setLockProperties(Properties lockProps) {
        this.lockProps = lockProps != null ? new Properties(lockProps) : new Properties();
        return this;
    }

    protected Properties getLockProperties() {
        return this.lockProps;
    }

    protected String getLockProperty(String key) {
        return this.lockProps != null ? this.lockProps.getProperty(key) : null;
    }

    public AbstractDLock init() {
        return this;
    }

    public void destroy() {
    }

    @Override
    public void close() {
        this.destroy();
    }

    @Override
    public LockResult lock(String clientId) {
        return this.lock(clientId, 60000L);
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        tsb.append("name", (Object)this.name).append("props", (Object)this.lockProps).append("clientId", (Object)this.clientId).append("timestampExpiry", this.timestampExpiry);
        return tsb.toString();
    }
}

