/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddth.dlock.impl;

import com.github.ddth.dlock.IDLockFactory;
import com.github.ddth.dlock.impl.AbstractDLock;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public abstract class AbstractDLockFactory
implements IDLockFactory,
AutoCloseable {
    private String lockNamePrefix;
    private Map<String, Properties> lockProperties;
    private Cache<String, AbstractDLock> lockInstances = CacheBuilder.newBuilder().expireAfterAccess(3600L, TimeUnit.SECONDS).removalListener((RemovalListener)new RemovalListener<String, AbstractDLock>(){

        public void onRemoval(RemovalNotification<String, AbstractDLock> notification) {
            AbstractDLock lock = (AbstractDLock)notification.getValue();
            lock.destroy();
        }
    }).build();

    public AbstractDLockFactory init() {
        return this;
    }

    public void destroy() {
        this.lockInstances.invalidateAll();
    }

    @Override
    public void close() {
        this.destroy();
    }

    protected String buildLockName(String lockName) {
        return this.lockNamePrefix != null ? this.lockNamePrefix + lockName : lockName;
    }

    public String getLockNamePrefix() {
        return this.lockNamePrefix;
    }

    public AbstractDLockFactory setLockNamePrefix(String lockNamePrefix) {
        this.lockNamePrefix = lockNamePrefix;
        return this;
    }

    public AbstractDLockFactory setLockProperties(Map<String, Properties> lockProperties) {
        this.lockProperties = lockProperties;
        return this;
    }

    protected Map<String, Properties> getLockPropertiesMap() {
        return this.lockProperties;
    }

    protected Properties getLockProperties(String name) {
        return this.lockProperties != null ? this.lockProperties.get(name) : null;
    }

    @Override
    public AbstractDLock createLock(final String name) {
        final String lockName = this.buildLockName(name);
        try {
            AbstractDLock lock = (AbstractDLock)this.lockInstances.get((Object)lockName, (Callable)new Callable<AbstractDLock>(){

                @Override
                public AbstractDLock call() throws Exception {
                    Properties lockProps = AbstractDLockFactory.this.getLockProperties(name);
                    return AbstractDLockFactory.this.createAndInitLockInstance(lockName, lockProps);
                }
            });
            return lock;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    protected AbstractDLock createAndInitLockInstance(String name, Properties lockProps) {
        AbstractDLock lock = this.createLockInternal(name, lockProps);
        lock.init();
        return lock;
    }

    protected abstract AbstractDLock createLockInternal(String var1, Properties var2);
}

