/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddth.dlock.impl.redis;

import com.github.ddth.dlock.LockResult;
import com.github.ddth.dlock.impl.redis.BaseRedisDLock;
import com.github.ddth.dlock.impl.redis.JedisConnector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisCluster;

public class ClusteredRedisDLock
extends BaseRedisDLock {
    private final Logger LOGGER = LoggerFactory.getLogger(ClusteredRedisDLock.class);
    public static final String LOCK_PROP_REDIS_HOSTS_AND_PORTS = "dlock.redis_hosts_and_ports";
    private String redisHostsAndPorts = "localhost:6379";

    public ClusteredRedisDLock(String name) {
        super(name);
    }

    public String getRedisHostsAndPorts() {
        return this.redisHostsAndPorts;
    }

    public ClusteredRedisDLock setRedisHostsAndPorts(String redisHostsAndPorts) {
        this.redisHostsAndPorts = redisHostsAndPorts;
        return this;
    }

    @Override
    public ClusteredRedisDLock init() {
        super.init();
        String hostsAndPorts = this.getLockProperty(LOCK_PROP_REDIS_HOSTS_AND_PORTS);
        if (!StringUtils.isBlank((CharSequence)hostsAndPorts)) {
            this.redisHostsAndPorts = hostsAndPorts;
        }
        if (this.getJedisConnector() == null) {
            try {
                JedisConnector jedisConnector = new JedisConnector();
                jedisConnector.setRedisHostsAndPorts(this.redisHostsAndPorts).init();
                this.setJedisConnector(jedisConnector);
            }
            catch (Exception e) {
                this.LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        return this;
    }

    protected JedisCluster getJedis() {
        return this.getJedisConnector().getJedisCluster();
    }

    @Override
    public LockResult lock(String clientId, long lockDurationMs) {
        if (StringUtils.isBlank((CharSequence)clientId)) {
            throw new IllegalArgumentException("Invalid ClientID!");
        }
        if (lockDurationMs <= 0L) {
            throw new IllegalArgumentException("Lock duration must be greater than zero!");
        }
        JedisCluster jedis = this.getJedis();
        String key = this.getName();
        Object response = jedis.eval(this.getScriptLock(), 0, new String[]{key, clientId, String.valueOf(lockDurationMs)});
        if (response == null) {
            return LockResult.HOLD_BY_ANOTHER_CLIENT;
        }
        return LockResult.SUCCESSFUL;
    }

    @Override
    public LockResult unlock(String clientId) {
        if (StringUtils.isBlank((CharSequence)clientId)) {
            throw new IllegalArgumentException("Invalid ClientID!");
        }
        JedisCluster jedis = this.getJedis();
        String key = this.getName();
        Object response = jedis.eval(this.getScriptUnlock(), 0, new String[]{key, clientId});
        if (response == null) {
            return LockResult.HOLD_BY_ANOTHER_CLIENT;
        }
        if ("0".equals(response.toString())) {
            return LockResult.NOT_FOUND;
        }
        return LockResult.SUCCESSFUL;
    }
}

