/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddth.dlock.impl.inmem;

import com.github.ddth.dlock.DLockException;
import com.github.ddth.dlock.LockResult;
import com.github.ddth.dlock.impl.AbstractDLock;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class InmemDLock
extends AbstractDLock {
    private Cache<String, LockEntry> locks = CacheBuilder.newBuilder().expireAfterAccess(86400L, TimeUnit.SECONDS).build();

    public InmemDLock(String name) {
        super(name);
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public LockResult lock(String clientId, long lockDurationMs) {
        if (StringUtils.isBlank((CharSequence)clientId)) {
            throw new IllegalArgumentException("Invalid ClientID!");
        }
        if (lockDurationMs <= 0L) {
            throw new IllegalArgumentException("Lock duration must be greater than zero!");
        }
        InmemDLock inmemDLock = this;
        synchronized (inmemDLock) {
            String key = this.getName();
            try {
                LockEntry lockEntry = (LockEntry)this.locks.getIfPresent((Object)key);
                if (lockEntry != null && !lockEntry.isExpired() && !StringUtils.equals((CharSequence)lockEntry.getClientId(), (CharSequence)clientId)) {
                    return LockResult.HOLD_BY_ANOTHER_CLIENT;
                }
                this.locks.put((Object)key, (Object)new LockEntry(clientId, lockDurationMs));
                return LockResult.SUCCESSFUL;
            }
            catch (Exception e) {
                throw e instanceof DLockException ? (DLockException)e : new DLockException(e);
            }
        }
    }

    @Override
    public LockResult unlock(String clientId) {
        if (StringUtils.isBlank((CharSequence)clientId)) {
            throw new IllegalArgumentException("Invalid ClientID!");
        }
        InmemDLock inmemDLock = this;
        synchronized (inmemDLock) {
            String key = this.getName();
            try {
                LockEntry lockEntry = (LockEntry)this.locks.getIfPresent((Object)key);
                if (lockEntry == null) {
                    return LockResult.NOT_FOUND;
                }
                if (!lockEntry.isExpired() && !StringUtils.equals((CharSequence)lockEntry.getClientId(), (CharSequence)clientId)) {
                    return LockResult.HOLD_BY_ANOTHER_CLIENT;
                }
                this.locks.invalidate((Object)key);
                return LockResult.SUCCESSFUL;
            }
            catch (Exception e) {
                throw e instanceof DLockException ? (DLockException)e : new DLockException(e);
            }
        }
    }

    private static class LockEntry {
        private String clientId;
        private long timestampExpiry;

        public LockEntry(String clientId, long ttlMs) {
            this.clientId = clientId;
            this.setTtl(ttlMs);
        }

        public String getClientId() {
            return this.clientId;
        }

        public LockEntry setTtl(long ttlMs) {
            this.timestampExpiry = System.currentTimeMillis() + ttlMs;
            return this;
        }

        public boolean isExpired() {
            return this.timestampExpiry < System.currentTimeMillis();
        }
    }
}

