/*
 * Decompiled with CFR 0.152.
 */
package waffle.apache;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.slf4j.LoggerFactory;
import waffle.apache.GenericWindowsPrincipal;
import waffle.apache.WaffleAuthenticatorBase;
import waffle.util.AuthorizationHeader;
import waffle.util.Base64;
import waffle.util.NtlmServletRequest;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsSecurityContext;

public class NegotiateAuthenticator
extends WaffleAuthenticatorBase {
    public NegotiateAuthenticator() {
        this._log = LoggerFactory.getLogger(NegotiateAuthenticator.class);
        this._info = "waffle.apache.NegotiateAuthenticator/1.0";
        this._log.debug("[waffle.apache.NegotiateAuthenticator] loaded");
    }

    public void start() {
        this._log.info("[waffle.apache.NegotiateAuthenticator] started");
    }

    public void stop() {
        this._log.info("[waffle.apache.NegotiateAuthenticator] stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean authenticate(Request request, Response response, LoginConfig loginConfig) {
        Object object = request.getUserPrincipal();
        AuthorizationHeader authorizationHeader = new AuthorizationHeader((HttpServletRequest)request);
        boolean bl = authorizationHeader.isNtlmType1PostAuthorizationHeader();
        this._log.debug(request.getMethod() + " " + request.getRequestURI() + ", contentlength: " + request.getContentLength());
        this._log.debug("authorization: " + authorizationHeader.toString() + ", ntlm post: " + bl);
        if (object != null && !bl) {
            this._log.debug("previously authenticated user: " + object.getName());
            return true;
        }
        if (!authorizationHeader.isNull()) {
            String string;
            Object object2;
            Object object3;
            String string2 = authorizationHeader.getSecurityPackage();
            String string3 = NtlmServletRequest.getConnectionId((HttpServletRequest)request);
            this._log.debug("security package: " + string2 + ", connection id: " + string3);
            if (bl) {
                this._auth.resetSecurityToken(string3);
            }
            IWindowsSecurityContext iWindowsSecurityContext = null;
            try {
                object3 = authorizationHeader.getTokenBytes();
                this._log.debug("token buffer: " + ((byte[])object3).length + " byte(s)");
                iWindowsSecurityContext = this._auth.acceptSecurityToken(string3, object3, string2);
                this._log.debug("continue required: " + iWindowsSecurityContext.isContinue());
                object2 = iWindowsSecurityContext.getToken();
                if (object2 != null && ((byte[])object2).length > 0) {
                    string = new String(Base64.encode((byte[])object2));
                    this._log.debug("continue token: " + string);
                    response.addHeader("WWW-Authenticate", string2 + " " + string);
                }
                if (iWindowsSecurityContext.isContinue() || bl) {
                    response.setHeader("Connection", "keep-alive");
                    response.setStatus(401);
                    response.flushBuffer();
                    return false;
                }
            }
            catch (Exception exception) {
                this._log.warn("error logging in user: " + exception.getMessage());
                this.sendUnauthorized(response);
                return false;
            }
            if (this.context == null || this.context.getRealm() == null) {
                this._log.warn("missing context/realm");
                response.setStatus(503);
                return false;
            }
            object3 = iWindowsSecurityContext.getIdentity();
            if (!this._allowGuestLogin && object3.isGuest()) {
                this._log.warn("guest login disabled: " + object3.getFqn());
                this.sendUnauthorized(response);
                return false;
            }
            try {
                this._log.debug("logged in user: " + object3.getFqn() + " (" + object3.getSidString() + ")");
                object2 = (Object)new GenericWindowsPrincipal((IWindowsIdentity)object3, this.context.getRealm(), this._principalFormat, this._roleFormat);
                this._log.debug("roles: " + ((GenericWindowsPrincipal)((Object)object2)).getRolesString());
                object = object2;
                string = request.getSession(true);
                this._log.debug("session id:" + string.getId());
                this.register(request, response, (Principal)object, string2, object.getName(), null);
                this._log.info("successfully logged in user: " + object.getName());
            }
            finally {
                object3.dispose();
            }
            return true;
        }
        this._log.debug("authorization required");
        this.sendUnauthorized(response);
        return false;
    }
}

