/*
 * Decompiled with CFR 0.152.
 */
package waffle.apache;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.slf4j.LoggerFactory;
import waffle.apache.GenericWindowsPrincipal;
import waffle.apache.WaffleAuthenticatorBase;
import waffle.util.AuthorizationHeader;
import waffle.util.Base64;
import waffle.util.NtlmServletRequest;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsSecurityContext;

public class MixedAuthenticator
extends WaffleAuthenticatorBase {
    public MixedAuthenticator() {
        this._log = LoggerFactory.getLogger(MixedAuthenticator.class);
        this._info = "waffle.apache.MixedAuthenticator/1.0";
        this._log.debug("[waffle.apache.MixedAuthenticator] loaded");
    }

    public void start() {
        this._log.info("[waffle.apache.MixedAuthenticator] started");
    }

    public void stop() {
        this._log.info("[waffle.apache.MixedAuthenticator] stopped");
    }

    protected boolean authenticate(Request request, Response response, LoginConfig loginConfig) {
        if (this.context == null || this.context.getRealm() == null) {
            this._log.warn("missing context/realm");
            response.setStatus(503);
            return false;
        }
        this._log.debug(request.getMethod() + " " + request.getRequestURI() + ", contentlength: " + request.getContentLength());
        boolean bl = request.getParameter("j_negotiate_check") != null;
        this._log.debug("negotiateCheck: " + bl);
        boolean bl2 = request.getParameter("j_security_check") != null;
        this._log.debug("securityCheck: " + bl2);
        Principal principal = request.getUserPrincipal();
        AuthorizationHeader authorizationHeader = new AuthorizationHeader((HttpServletRequest)request);
        boolean bl3 = authorizationHeader.isNtlmType1PostAuthorizationHeader();
        this._log.debug("authorization: " + authorizationHeader.toString() + ", ntlm post: " + bl3);
        if (principal != null && !bl3) {
            this._log.debug("previously authenticated user: " + principal.getName());
            return true;
        }
        if (bl) {
            if (!authorizationHeader.isNull()) {
                return this.negotiate(request, response, authorizationHeader);
            }
            this._log.debug("authorization required");
            this.sendUnauthorized(response);
            return false;
        }
        if (bl2) {
            boolean bl4 = this.post(request, response, loginConfig);
            if (bl4) {
                this.redirectTo(request, response, request.getServletPath());
            } else {
                this.redirectTo(request, response, loginConfig.getErrorPage());
            }
            return bl4;
        }
        this.redirectTo(request, response, loginConfig.getLoginPage());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean negotiate(Request request, Response response, AuthorizationHeader authorizationHeader) {
        String string;
        Object object;
        Object object2;
        String string2 = authorizationHeader.getSecurityPackage();
        String string3 = NtlmServletRequest.getConnectionId((HttpServletRequest)request);
        this._log.debug("security package: " + string2 + ", connection id: " + string3);
        boolean bl = authorizationHeader.isNtlmType1PostAuthorizationHeader();
        if (bl) {
            this._auth.resetSecurityToken(string3);
        }
        IWindowsSecurityContext iWindowsSecurityContext = null;
        try {
            object2 = authorizationHeader.getTokenBytes();
            this._log.debug("token buffer: " + ((byte[])object2).length + " byte(s)");
            iWindowsSecurityContext = this._auth.acceptSecurityToken(string3, object2, string2);
            this._log.debug("continue required: " + iWindowsSecurityContext.isContinue());
            object = iWindowsSecurityContext.getToken();
            if (object != null && ((byte[])object).length > 0) {
                string = new String(Base64.encode((byte[])object));
                this._log.debug("continue token: " + string);
                response.addHeader("WWW-Authenticate", string2 + " " + string);
            }
            if (iWindowsSecurityContext.isContinue() || bl) {
                response.setHeader("Connection", "keep-alive");
                response.setStatus(401);
                response.flushBuffer();
                return false;
            }
        }
        catch (Exception exception) {
            this._log.warn("error logging in user: " + exception.getMessage());
            this.sendUnauthorized(response);
            return false;
        }
        object2 = iWindowsSecurityContext.getIdentity();
        if (!this._allowGuestLogin && object2.isGuest()) {
            this._log.warn("guest login disabled: " + object2.getFqn());
            this.sendUnauthorized(response);
            return false;
        }
        try {
            this._log.debug("logged in user: " + object2.getFqn() + " (" + object2.getSidString() + ")");
            object = (Object)new GenericWindowsPrincipal((IWindowsIdentity)object2, this.context.getRealm(), this._principalFormat, this._roleFormat);
            this._log.debug("roles: " + ((GenericWindowsPrincipal)((Object)object)).getRolesString());
            string = request.getSession(true);
            this._log.debug("session id:" + string.getId());
            this.register(request, response, (Principal)object, string2, object.getName(), null);
            this._log.info("successfully logged in user: " + object.getName());
        }
        finally {
            object2.dispose();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean post(Request request, Response response, LoginConfig loginConfig) {
        String string = request.getParameter("j_username");
        String string2 = request.getParameter("j_password");
        this._log.debug("logging in: " + string);
        IWindowsIdentity iWindowsIdentity = null;
        try {
            iWindowsIdentity = this._auth.logonUser(string, string2);
        }
        catch (Exception exception) {
            this._log.error(exception.getMessage());
            return false;
        }
        if (!this._allowGuestLogin && iWindowsIdentity.isGuest()) {
            this._log.warn("guest login disabled: " + iWindowsIdentity.getFqn());
            return false;
        }
        try {
            this._log.debug("successfully logged in " + string + " (" + iWindowsIdentity.getSidString() + ")");
            GenericWindowsPrincipal genericWindowsPrincipal = new GenericWindowsPrincipal(iWindowsIdentity, this.context.getRealm(), this._principalFormat, this._roleFormat);
            this._log.debug("roles: " + genericWindowsPrincipal.getRolesString());
            HttpSession httpSession = request.getSession(true);
            this._log.debug("session id:" + httpSession.getId());
            this.register(request, response, (Principal)((Object)genericWindowsPrincipal), "FORM", genericWindowsPrincipal.getName(), null);
            this._log.info("successfully logged in user: " + genericWindowsPrincipal.getName());
        }
        finally {
            iWindowsIdentity.dispose();
        }
        return true;
    }

    private void redirectTo(Request request, Response response, String string) {
        try {
            this._log.debug("redirecting to: " + string);
            ServletContext servletContext = this.context.getServletContext();
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(string);
            requestDispatcher.forward((ServletRequest)request.getRequest(), (ServletResponse)response);
        }
        catch (IOException iOException) {
            this._log.error(iOException.getMessage());
            throw new RuntimeException(iOException);
        }
        catch (ServletException servletException) {
            this._log.error(servletException.getMessage());
            throw new RuntimeException(servletException);
        }
    }
}

