/*
 * Decompiled with CFR 0.152.
 */
package waffle.apache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import waffle.windows.auth.IWindowsAccount;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.PrincipalFormat;
import waffle.windows.auth.WindowsAccount;

public class GenericWindowsPrincipal
extends GenericPrincipal {
    private byte[] _sid;
    private String _sidString;
    private Map<String, WindowsAccount> _groups;

    public GenericWindowsPrincipal(IWindowsIdentity iWindowsIdentity, Realm realm, PrincipalFormat principalFormat, PrincipalFormat principalFormat2) {
        super(realm, iWindowsIdentity.getFqn(), "", GenericWindowsPrincipal.getRoles(iWindowsIdentity, principalFormat, principalFormat2));
        this._sid = iWindowsIdentity.getSid();
        this._sidString = iWindowsIdentity.getSidString();
        this._groups = GenericWindowsPrincipal.getGroups(iWindowsIdentity.getGroups());
    }

    private static List<String> getRoles(IWindowsIdentity iWindowsIdentity, PrincipalFormat principalFormat, PrincipalFormat principalFormat2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(GenericWindowsPrincipal.getPrincipalNames(iWindowsIdentity, principalFormat));
        for (IWindowsAccount iWindowsAccount : iWindowsIdentity.getGroups()) {
            arrayList.addAll(GenericWindowsPrincipal.getRoleNames(iWindowsAccount, principalFormat2));
        }
        return arrayList;
    }

    private static Map<String, WindowsAccount> getGroups(IWindowsAccount[] iWindowsAccountArray) {
        HashMap<String, WindowsAccount> hashMap = new HashMap<String, WindowsAccount>();
        for (IWindowsAccount iWindowsAccount : iWindowsAccountArray) {
            hashMap.put(iWindowsAccount.getFqn(), new WindowsAccount(iWindowsAccount));
        }
        return hashMap;
    }

    public byte[] getSid() {
        return (byte[])this._sid.clone();
    }

    public String getSidString() {
        return this._sidString;
    }

    public Map<String, WindowsAccount> getGroups() {
        return this._groups;
    }

    private static List<String> getRoleNames(IWindowsAccount iWindowsAccount, PrincipalFormat principalFormat) {
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (principalFormat) {
            case fqn: {
                arrayList.add(iWindowsAccount.getFqn());
                break;
            }
            case sid: {
                arrayList.add(iWindowsAccount.getSidString());
                break;
            }
            case both: {
                arrayList.add(iWindowsAccount.getFqn());
                arrayList.add(iWindowsAccount.getSidString());
                break;
            }
        }
        return arrayList;
    }

    private static List<String> getPrincipalNames(IWindowsIdentity iWindowsIdentity, PrincipalFormat principalFormat) {
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (principalFormat) {
            case fqn: {
                arrayList.add(iWindowsIdentity.getFqn());
                break;
            }
            case sid: {
                arrayList.add(iWindowsIdentity.getSidString());
                break;
            }
            case both: {
                arrayList.add(iWindowsIdentity.getFqn());
                arrayList.add(iWindowsIdentity.getSidString());
                break;
            }
        }
        return arrayList;
    }

    public String getRolesString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.getRoles()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

