/*
 * Decompiled with CFR 0.152.
 */
package waffle.util;

import com.google.common.io.BaseEncoding;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import waffle.util.NtlmMessage;
import waffle.util.SPNegoMessage;

public class AuthorizationHeader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizationHeader.class);
    private final HttpServletRequest request;

    public AuthorizationHeader(HttpServletRequest httpServletRequest) {
        this.request = httpServletRequest;
    }

    public String getHeader() {
        return this.request.getHeader("Authorization");
    }

    public boolean isNull() {
        return this.getHeader() == null || this.getHeader().length() == 0;
    }

    public String getSecurityPackage() {
        String header = this.getHeader();
        if (header == null) {
            throw new RuntimeException("Missing Authorization: header");
        }
        int space = header.indexOf(32);
        if (space > 0) {
            return header.substring(0, space);
        }
        throw new RuntimeException("Invalid Authorization header: " + header);
    }

    public String toString() {
        return this.isNull() ? "<none>" : this.getHeader();
    }

    public String getToken() {
        return this.getHeader().substring(this.getSecurityPackage().length() + 1);
    }

    public byte[] getTokenBytes() {
        try {
            return BaseEncoding.base64().decode((CharSequence)this.getToken());
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("", (Throwable)e);
            throw new RuntimeException("Invalid authorization header.");
        }
    }

    public boolean isNtlmType1Message() {
        if (this.isNull()) {
            return false;
        }
        byte[] tokenBytes = this.getTokenBytes();
        if (!NtlmMessage.isNtlmMessage(tokenBytes)) {
            return false;
        }
        return 1 == NtlmMessage.getMessageType(tokenBytes);
    }

    public boolean isSPNegoMessage() {
        if (this.isNull()) {
            return false;
        }
        byte[] tokenBytes = this.getTokenBytes();
        return SPNegoMessage.isSPNegoMessage(tokenBytes);
    }

    public boolean isNtlmType1PostAuthorizationHeader() {
        if (!this.request.getMethod().equals("POST") && !this.request.getMethod().equals("PUT")) {
            return false;
        }
        if (this.request.getContentLength() != 0) {
            return false;
        }
        return this.isNtlmType1Message() || this.isSPNegoMessage();
    }
}

