/*
 * Decompiled with CFR 0.152.
 */
package waffle.servlet.spi;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import waffle.servlet.spi.BasicSecurityFilterProvider;
import waffle.servlet.spi.NegotiateSecurityFilterProvider;
import waffle.servlet.spi.SecurityFilterProvider;
import waffle.util.AuthorizationHeader;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsIdentity;

public class SecurityFilterProviderCollection {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityFilterProviderCollection.class);
    private List<SecurityFilterProvider> providers = new ArrayList<SecurityFilterProvider>();

    public SecurityFilterProviderCollection(SecurityFilterProvider[] providerArray) {
        for (SecurityFilterProvider provider : providerArray) {
            LOGGER.info("using '{}'", (Object)provider.getClass().getName());
            this.providers.add(provider);
        }
    }

    public SecurityFilterProviderCollection(String[] providerNames, IWindowsAuthProvider auth) {
        for (String providerName : providerNames) {
            providerName = providerName.trim();
            LOGGER.info("loading '{}'", (Object)providerName);
            try {
                Class<?> providerClass = Class.forName(providerName);
                Constructor<?> c = providerClass.getConstructor(IWindowsAuthProvider.class);
                SecurityFilterProvider provider = (SecurityFilterProvider)c.newInstance(auth);
                this.providers.add(provider);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("error loading '{}': {}", (Object)providerName, (Object)e.getMessage());
                LOGGER.trace("{}", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                LOGGER.error("error loading '{}': {}", (Object)providerName, (Object)e.getMessage());
                LOGGER.trace("{}", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("error loading '{}': {}", (Object)providerName, (Object)e.getMessage());
                LOGGER.trace("{}", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("error loading '{}': {}", (Object)providerName, (Object)e.getMessage());
                LOGGER.trace("{}", (Throwable)e);
            }
            catch (InstantiationException e) {
                LOGGER.error("error loading '{}': {}", (Object)providerName, (Object)e.getMessage());
                LOGGER.trace("{}", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("error loading '{}': {}", (Object)providerName, (Object)e.getMessage());
                LOGGER.trace("{}", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("error loading '{}': {}", (Object)providerName, (Object)e.getMessage());
                LOGGER.trace("{}", (Throwable)e);
            }
        }
    }

    public SecurityFilterProviderCollection(IWindowsAuthProvider auth) {
        this.providers.add(new NegotiateSecurityFilterProvider(auth));
        this.providers.add(new BasicSecurityFilterProvider(auth));
    }

    public boolean isSecurityPackageSupported(String securityPackage) {
        return this.get(securityPackage) != null;
    }

    private SecurityFilterProvider get(String securityPackage) {
        for (SecurityFilterProvider provider : this.providers) {
            if (!provider.isSecurityPackageSupported(securityPackage)) continue;
            return provider;
        }
        return null;
    }

    public IWindowsIdentity doFilter(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuthorizationHeader authorizationHeader = new AuthorizationHeader(request);
        SecurityFilterProvider provider = this.get(authorizationHeader.getSecurityPackage());
        if (provider == null) {
            throw new RuntimeException("Unsupported security package: " + authorizationHeader.getSecurityPackage());
        }
        return provider.doFilter(request, response);
    }

    public boolean isPrincipalException(HttpServletRequest request) {
        for (SecurityFilterProvider provider : this.providers) {
            if (!provider.isPrincipalException(request)) continue;
            return true;
        }
        return false;
    }

    public void sendUnauthorized(HttpServletResponse response) {
        for (SecurityFilterProvider provider : this.providers) {
            provider.sendUnauthorized(response);
        }
    }

    public int size() {
        return this.providers.size();
    }

    public SecurityFilterProvider getByClassName(String name) throws ClassNotFoundException {
        for (SecurityFilterProvider provider : this.providers) {
            if (!provider.getClass().getName().equals(name)) continue;
            return provider;
        }
        throw new ClassNotFoundException(name);
    }
}

