/*
 * Decompiled with CFR 0.152.
 */
package waffle.windows.auth.impl;

import com.sun.jna.platform.win32.Netapi32Util;
import waffle.windows.auth.IWindowsDomain;

public class WindowsDomainImpl
implements IWindowsDomain {
    private String _fqn;
    private TrustDirection _trustDirection = TrustDirection.Bidirectional;
    private TrustType _trustType = TrustType.Unknown;

    @Override
    public String getFqn() {
        return this._fqn;
    }

    @Override
    public String getTrustDirectionString() {
        return this._trustDirection.toString();
    }

    @Override
    public String getTrustTypeString() {
        return this._trustType.toString();
    }

    public WindowsDomainImpl(String string) {
        this._fqn = string;
    }

    public WindowsDomainImpl(Netapi32Util.DomainTrust domainTrust) {
        this._fqn = domainTrust.DnsDomainName;
        if (this._fqn == null || this._fqn.length() == 0) {
            this._fqn = domainTrust.NetbiosDomainName;
        }
        if (domainTrust.isInbound() && domainTrust.isOutbound()) {
            this._trustDirection = TrustDirection.Bidirectional;
        } else if (domainTrust.isOutbound()) {
            this._trustDirection = TrustDirection.Outbound;
        } else if (domainTrust.isInbound()) {
            this._trustDirection = TrustDirection.Inbound;
        }
        if (domainTrust.isInForest()) {
            this._trustType = TrustType.Forest;
        } else if (domainTrust.isRoot()) {
            this._trustType = TrustType.TreeRoot;
        }
    }

    private static enum TrustType {
        TreeRoot,
        ParentChild,
        CrossLink,
        External,
        Forest,
        Kerberos,
        Unknown;

    }

    private static enum TrustDirection {
        Inbound,
        Outbound,
        Bidirectional;

    }
}

