/*
 * Decompiled with CFR 0.152.
 */
package waffle.windows.auth.impl;

import com.sun.jna.platform.win32.Netapi32Util;
import java.util.ArrayList;
import waffle.windows.auth.IWindowsComputer;

public class WindowsComputerImpl
implements IWindowsComputer {
    private String computerName;
    private String domainName;

    @Override
    public String getComputerName() {
        return this.computerName;
    }

    @Override
    public String[] getGroups() {
        Netapi32Util.LocalGroup[] localGroupArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Netapi32Util.LocalGroup localGroup : localGroupArray = Netapi32Util.getLocalGroups((String)this.computerName)) {
            arrayList.add(localGroup.name);
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public String getJoinStatus() {
        int n = Netapi32Util.getJoinStatus((String)this.computerName);
        switch (n) {
            case 3: {
                return "NetSetupDomainName";
            }
            case 1: {
                return "NetSetupUnjoined";
            }
            case 2: {
                return "NetSetupWorkgroupName";
            }
            case 0: {
                return "NetSetupUnknownStatus";
            }
        }
        throw new RuntimeException("Unsupported join status: " + n);
    }

    @Override
    public String getMemberOf() {
        return this.domainName;
    }

    public WindowsComputerImpl(String string) {
        this.computerName = string;
        this.domainName = Netapi32Util.getDomainName((String)string);
    }
}

