/*
 * Decompiled with CFR 0.152.
 */
package waffle.util;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.sun.jna.Platform;
import com.sun.jna.platform.WindowUtils;
import com.sun.jna.platform.win32.Netapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import java.awt.Desktop;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import waffle.windows.auth.IWindowsAccount;
import waffle.windows.auth.IWindowsComputer;
import waffle.windows.auth.IWindowsDomain;
import waffle.windows.auth.impl.WindowsAccountImpl;
import waffle.windows.auth.impl.WindowsAuthProviderImpl;

public class WaffleInfo {
    public Document getWaffleInfo() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("waffle");
        String string = WaffleInfo.class.getPackage().getImplementationVersion();
        if (string != null) {
            element.setAttribute("version", string);
        }
        if ((string = Platform.class.getPackage().getImplementationVersion()) != null) {
            element.setAttribute("jna", string);
        }
        if ((string = WindowUtils.class.getPackage().getImplementationVersion()) != null) {
            element.setAttribute("jna-platform", string);
        }
        document.appendChild(element);
        element.appendChild(this.getAuthProviderInfo(document));
        return document;
    }

    protected Element getAuthProviderInfo(Document document) {
        Element element;
        WindowsAuthProviderImpl windowsAuthProviderImpl = new WindowsAuthProviderImpl();
        Element element2 = document.createElement("auth");
        element2.setAttribute("class", windowsAuthProviderImpl.getClass().getName());
        Element element3 = document.createElement("currentUser");
        element2.appendChild(element3);
        String string = WindowsAccountImpl.getCurrentUsername();
        this.addAccountInfo(document, element3, new WindowsAccountImpl(string));
        element3 = document.createElement("computer");
        element2.appendChild(element3);
        IWindowsComputer iWindowsComputer = windowsAuthProviderImpl.getCurrentComputer();
        Element element4 = document.createElement("computerName");
        element4.setTextContent(iWindowsComputer.getComputerName());
        element3.appendChild(element4);
        element4 = document.createElement("memberOf");
        element4.setTextContent(iWindowsComputer.getMemberOf());
        element3.appendChild(element4);
        element4 = document.createElement("joinStatus");
        element4.setTextContent(iWindowsComputer.getJoinStatus());
        element3.appendChild(element4);
        element4 = document.createElement("groups");
        for (String object : iWindowsComputer.getGroups()) {
            element = document.createElement("group");
            element.setTextContent(object);
            element4.appendChild(element);
        }
        element3.appendChild(element4);
        if (Netapi32Util.getJoinStatus() == 3) {
            element3 = document.createElement("domains");
            element2.appendChild(element3);
            for (IWindowsDomain iWindowsDomain : windowsAuthProviderImpl.getDomains()) {
                element = document.createElement("domain");
                element2.appendChild(element);
                element4 = document.createElement("FQN");
                element4.setTextContent(iWindowsDomain.getFqn());
                element3.appendChild(element4);
                element4 = document.createElement("TrustTypeString");
                element4.setTextContent(iWindowsDomain.getTrustTypeString());
                element3.appendChild(element4);
                element4 = document.createElement("TrustDirectionString");
                element4.setTextContent(iWindowsDomain.getTrustDirectionString());
                element3.appendChild(element4);
            }
        }
        return element2;
    }

    protected void addAccountInfo(Document document, Element element, IWindowsAccount iWindowsAccount) {
        Element element2 = document.createElement("Name");
        element2.setTextContent(iWindowsAccount.getName());
        element.appendChild(element2);
        element2 = document.createElement("FQN");
        element2.setTextContent(iWindowsAccount.getFqn());
        element.appendChild(element2);
        element2 = document.createElement("Domain");
        element2.setTextContent(iWindowsAccount.getDomain());
        element.appendChild(element2);
        element2 = document.createElement("SID");
        element2.setTextContent(iWindowsAccount.getSidString());
        element.appendChild(element2);
    }

    public Element getLookupInfo(Document document, String string) {
        WindowsAuthProviderImpl windowsAuthProviderImpl = new WindowsAuthProviderImpl();
        Element element = document.createElement("lookup");
        element.setAttribute("name", string);
        try {
            this.addAccountInfo(document, element, windowsAuthProviderImpl.lookupAccount(string));
        }
        catch (Win32Exception win32Exception) {
            element.appendChild(WaffleInfo.getException(document, (Exception)((Object)win32Exception)));
        }
        return element;
    }

    public static Element getException(Document document, Exception exception) {
        Element element = document.createElement("exception");
        element.setAttribute("class", exception.getClass().getName());
        Element element2 = document.createElement("message");
        if (exception.getMessage() != null) {
            element2.setTextContent(exception.getMessage());
            element.appendChild(element2);
        }
        element2 = document.createElement("trace");
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        element2.setTextContent(((Object)stringWriter).toString());
        element.appendChild(element2);
        return element;
    }

    public static String toPrettyXML(Document document) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        DOMSource dOMSource = new DOMSource(document);
        transformer.transform(dOMSource, streamResult);
        return stringWriter.toString();
    }

    public static void main(String[] stringArray) {
        Object object;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i];
                if ("-show".equals(object)) {
                    bl = true;
                    continue;
                }
                if (((String)object).equals("-lookup")) {
                    arrayList.add(stringArray[++i]);
                    continue;
                }
                System.err.println("Unknown Argument: " + (String)object);
                System.exit(1);
            }
        }
        WaffleInfo waffleInfo = new WaffleInfo();
        try {
            object = waffleInfo.getWaffleInfo();
            for (String object2 : arrayList) {
                object.getDocumentElement().appendChild(waffleInfo.getLookupInfo((Document)object, object2));
            }
            String string = WaffleInfo.toPrettyXML((Document)object);
            if (bl) {
                File file = File.createTempFile("waffle-info-", ".xml");
                Files.write((CharSequence)string, (File)file, (Charset)Charsets.UTF_8);
                Desktop.getDesktop().open(file);
            } else {
                System.out.println(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

